/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;
import java.awt.event.*;


/** Message Dialog class.
  * Show message dialog and you can let an user input
  * something.
  */

public class InputDialog extends AbstractDialog {

    protected String data;
    protected boolean noEmpty = false;

    protected Label label;
    protected TextField field;

    //=====================
    // constructor
    //=====================

    public InputDialog(Frame parent,String windowTitle,
			 String message) {
	super(parent,windowTitle,Style_OKCANCEL);
	label.setText(message);
	pack();
    }
    //=====================
    // operation
    //=====================

    public String getData() {return data;}
    public void setData(String d) {data = d;}

    public boolean doModal() {
	if (data == null) {
	    field.setText("");
	} else {
	    field.setText(data);
	}
	return super.doModal();
    }

    //=====================
    // private area
    //=====================

    protected void onOk() {
	data = field.getText();
    }

    /** This method builds Dialog components.
      * you make a new panel and  put some components on it.
      */
    protected Panel init() {
	Panel p = new Panel(new BorderLayout());
	label = new Label("message dialog");
	p.add(label,"North");
	field = new TextField(30);
	field.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		onOkRoot();
	    }
	});
	p.add(field,"Center");
	return p;
    }

    //=====================
    // test method
    //=====================

    public static void main(String [] a) {
	Frame f = new WFrame("message test");
	f.add(new Label("[hello]"),"Center");
	f.pack();
	f.show();
	InputDialog d = new InputDialog(f,"Window Title","Message");
	d.doModal();
    }
}
