/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;
import jp.gr.java_conf.ccs2.math.Parameter;


/**
 * <p>Numerical text field with maximal and minimum filter.</p>
 * The filter is optional function. You can choose either 
 * maximal or minimum filter, you need.
 */
public class NumberField extends TextField{

    double max=0,min=0;
    boolean maxb=false,minb=false;

    /**
     * construct with default value, max and  minimum value.
     */
    public NumberField(double init,double max,double min) {
	this(init);
	setMax(max);
	setMin(min);
    }

    /**
     * construct with default value.
     */
    public NumberField(double init) {
	super(d2s(init));
    }

    /**
     * Default constructor
     */
    public NumberField() {
	super();
    }
    
    //=========================

    /** set maximal filter */
    public void setMax(double m) {
	max = m;maxb=true;
	if (minb) {
	    if (min>max)
		System.out.println("bad range:NumberField");
	}
    }
    /** Clear maximal filter. */
    public void clearMax() {maxb=false;}

    /** set minimum filter */
    public void setMin(double m) {
	min = m;minb=true;
	if (maxb) {
	    if (min>max)
		System.out.println("bad range:NumberField");
	}
    }
    /** clear minimum filter */
    public void clearMin() {minb=false;}


    /** Get the field value. Exception-less version */
    public double getValue() throws NumberFormatException {
	double x =  s2d(getText());
	if (maxb && x>max) throw new NumberFormatException();
	if (minb && x<min) throw new NumberFormatException();
	return x;
    }

    /** Get the field value. This method throws exception when some
     * trouble occur. */
    public double getValues(double def) {
	double x = def;
	try {
	    x = s2d(getText());
	    if (maxb && x>max) throw new NumberFormatException();
	    if (minb && x<min) throw new NumberFormatException();
	    return x;
	} catch (NumberFormatException e) {
	}
	return def;
    }

    /** set numerical value */
    public void setValue(double a) {
	setText(d2s(a));
    }

    //=========================

    static protected String d2s(double d) {
	return Double.toString(d);
    }

    static protected double s2d(String s) throws NumberFormatException {
	double x = Double.valueOf(s).doubleValue();
	return x;
    }
}
