/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;



/** a interface that paints the specified rectangle */
public abstract class RectPainter {

    protected RectPainter prepainter=null;

    /** default constructor with no pre-paint object. */
    protected RectPainter() { this(null); }

    /**
       construct with pre-paint object.
       @param r pre-paint object (RectPainter)
     */
    protected RectPainter(RectPainter r) {
	prepainter = r;
    }

    /** 
	called by parent object to paint the given rectangle area.
	@param  g graphics context
	@param  r the reactangle to paint
     */
    public final void paint(Graphics g,Rectangle r) {
	if (prepainter != null) prepainter.paint(g,r);
	work(g,r);
    }

    /** set pre-paint object.  */
    public final void setPrepainter(RectPainter r) {
	prepainter = r;
    }
    /** get pre-paint object */
    public final RectPainter getPrepainter() { return prepainter; }

    /** paint method that should be implemented by subclass
	@param g graphics context
	@param r the rectangle to paint
     */
    protected abstract void work(Graphics g,Rectangle r);
}
