/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;
import java.awt.event.*;
import java.util.*;


/** This class provides the tabbed panel.
  * You can use tabbed panel controle in JDK1.1
  * environment.
  * You can see how to use this component to see
  * "main" method.
  */
public class TabPanel extends Panel {

    //====(contructor)==========================

    public TabPanel() {this(null);}

    public TabPanel(MessageListener p) {
	super();
	init();
	if (p != null)
	    addMessageListener(p);
    }

    //====(operation)==========================

    /** add a component.
      * @param a your component
      * @param title page title, used on a tab
      * @return the key to access the page.
      */
    public String addPage(Component a,String title) {
	String key = getID();
	client.add(a,key);
	tabs.addTab((String)title,key);
	comps.put(key,a);
	doLayout();
	return key;
    }

    public String add(Component a,String title) {
	return addPage(a,title);
    }

    /** remove the page.
      * @param key access key.
      */
    public void remove(String key) {
	try {
	    Component cp = (Component)comps.get(key);
	    client.remove(cp);
	    tabs.removeTab(key);
	    comps.remove(key);
	    String k = tabs.getActive();
	    change(k);
	} catch(Exception e) {
	    System.out.println("TabPanel:removal error. ("+key+")");
	}
    }

    /** remove all pages.
      */
    public void removeAll() {
	try {
	    client.removeAll();
	    tabs.removeAllTabs();
	    comps.clear();
	} catch(Exception e) {
	    System.out.println("TabPanel:removal error. ");
	}
    }

    /** change the page.
      * @param key access key.
      */
    public void change(String key) {
	tabs.setActive(key);
	layout.show(client,key);
	doLayout();
    }

    public String getActive() {
	return tabs.getActive();
    }

    public void addMessageListener(MessageListener m) {
	tabs.addMessageListener(m);
    }

    public Dimension getPreferredSize() {
	Dimension d = super.getPreferredSize();
	return d;
    }

    //====(private area)==========================

    public void doLayout() {
	super.doLayout();
	client.doLayout();
    }

    protected TabCtrl tabs;
    protected CardLayout layout;
    protected Panel client;
    protected Hashtable comps = new Hashtable();

    protected void init() {
	setLayout(new BorderLayout());
	layout = new CardLayout();
	client = new Panel();
	client.setLayout(layout);
	tabs = new TabCtrl();
	tabs.addMessageListener(new MessageListener() {
	    public void message(String mes,int cd, Object obj) {
		change((String)obj);
	    }
	});
	super.add(tabs,"North");
	super.add(client,"Center");
    }

    private int address=0;
    private String getID() {
	address++;
	return "t"+address;
    }

    //====(test method)==================================

    public static void main(String [] args) {
	WFrame f = new WFrame("tab panel test");
	TabPanel panel = new TabPanel();
	panel.add(new Shader("hello label"),"hello");
	panel.add(new Label("Second Pane"),"second");
	panel.add(new Label("Next generation"),"Next generations!");
	f.add(panel);
	f.setSize(400,300);
	f.show();
    }
}
