/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import jp.gr.java_conf.ccs2.comp.*;
import jp.gr.java_conf.ccs2.util.*;
import jp.gr.java_conf.ccs2.math.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import jp.gr.java_conf.ccs2.util.Comparable;


/** TreeStructure data viewer implemented by Graphics tree */
public class TreeStructureViewer {

    public TreeStructureViewer(TreeStructure root) {
	setTree(root);
    }

    public void setTree(TreeStructure root) {
	show(root);
    }

    Frame frame;
    TreeViewer tree;

    protected void show(TreeStructure root) {
	if (frame == null) {
	    frame = new WFrame("Tree Viewer");
	    frame.setSize(600,500);
	}
	//
	if (tree == null) {
	    tree = new TreeViewer(root);
	    ScrollPane sc = new ScrollPane();
	    sc.add(tree);
	    frame.add(sc);
	} else {
	    tree.setModel(root);
	}
	frame.show();
    }
    
    public static void main(String [] args) {
	/*
	BTree tr = new BTree();
	tr.addElement(n(2));//root   2
	tr.addElement(n(3));//    1     3
	tr.addElement(n(1));//             5
 	tr.addElement(n(5));//          4     6
	tr.addElement(n(4));//         
	tr.addElement(n(6));//            
	TreeStructureViewer sw = new TreeStructureViewer(tr);
	*/
	
	AFunction af = AFunctionClass.getFunction("x+(x+1)**2+sin(a+exp(x))");
	TreeStructureViewer sw = new TreeStructureViewer((TreeStructure)af);
    }

    static Comparable n(double a) {
	final double aa = a;
	return new ComparableClass() {
		double num = aa;
		public double getValue() {return num;}
		public String toString() {return ""+getValue();}
	    };
    }


    class TreeViewer extends BufferedCanvas {

	int vSpace = 15;
	int hSpace = 15;

	OriginalFont fontInfo = new OriginalFont(
	    Color.black,Color.lightGray,
	    new Font("Serif",Font.PLAIN,16));

	TreeViewer(TreeStructure t) {
	    setModel(t);
	    setHeavyContents(true);
	}

	public void setModel(TreeStructure t) {
	    root = t;
	}

	TreeStructure root;
	Vector paintList = new Vector();

	public void bpaint(Graphics g) {
	    PaintNode node = adjustSize(g);
	    painter(g,node,new Point(hSpace,vSpace),null);
	}

	PaintNode adjustSize(Graphics g) {
	    int width = 0;
	    int height = 0;
	    paintList.removeAllElements();
	    PaintNode tree = calcSize(g,root);
	    int ww = tree.w + hSpace*2;
	    int hh = tree.h + vSpace*2;
	    setSize( ww, hh);
	    return tree;
	}

	PaintNode calcSize(Graphics g,TreeStructure node) {
	    RichString name = new RichString(
		node.getTreeNodeExpression(),fontInfo);
	    Dimension tdim = name.getSize(g);
	
	    TreeStructure [] children = node.getTreeNodes();
	    Dimension dim = new Dimension(0,0);
	    PaintNode [] nodes = null;
	    if (children != null && children.length > 0) {
		nodes = new PaintNode[children.length];
		for (int i=0;i<children.length;i++) {
		    PaintNode r = calcSize(g,children[i]);
		    nodes[i] = r;
		    dim.width += r.w + hSpace;
		    if (dim.height < r.h)
			dim.height = r.h;
		}
		dim.height += tdim.height + vSpace;
	    } else {
		dim = new Dimension(tdim.width,tdim.height);
	    }
	    return new PaintNode(name,dim.width,dim.height,nodes);
	}

	/**
	   @param node current node
	   @param ps current tree left-upper position
	*/
	void painter(Graphics g, PaintNode node, Point ps, Point con) {
	    Dimension tdim = node.name.getSize(g);
	    //current node left-upper position
	    int mx = ps.x + node.w/2 - tdim.width/2;
	    int my = ps.y;
	    if (node.children != null) {
		//modulation
		int avx = 0;
		int xx = 0;
		for (int i=0;i<node.children.length;i++) {
		    avx += ps.x + xx + node.children[i].w/2;
		    xx += node.children[i].w + hSpace;
		}
		mx = avx / node.children.length - tdim.width/2;
	    } 
	    if (con != null)
		g.drawLine(mx + tdim.width/2,my, con.x,con.y);
	    node.name.drawContents(g,mx,my);
	    Point myCon = new Point(mx+ tdim.width/2, my+tdim.height);
	    if (node.children != null) {
		int xx = 0;
		for (int i=0;i<node.children.length;i++) {
		    int cx = ps.x + xx;
		    int cy = ps.y + tdim.height + vSpace;
		    painter(g, node.children[i],new Point( cx, cy),myCon);
		    xx += node.children[i].w + hSpace;
		}
	    }
	}

	class PaintNode {
	    PaintNode (RichString n,int w,int h,PaintNode [] ns) {
		this.name = n;
		this.w = w;this.h = h;
		this.children = ns;
	    }
	    RichString name;
	    int x,y;
	    int w,h;
	    PaintNode [] children;
	}

    }
}

