/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp.swing;
import java.awt.FlowLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Container;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.*;
import java.util.*;
import java.text.*;
import jp.gr.java_conf.ccs2.core.CCSResource;
import jp.gr.java_conf.ccs2.util.StringUtil;


/** Date field component.  */
public class DateComponent extends JPanel {

    Date date;
    String hint;
    boolean readonly=false;

    //==========================
    // constructors
    //==========================

    /** Default constructor */
    public DateComponent() {
	this(null);
    }

    /** 
     * @param h field name.
     * When the mouse cursol is on this panel, or 
     * the error case, this string will be showed.
     */
    public DateComponent(String h) {
	this(new Date(),h,false);
    }

    /** 
     * @param init initial date
     * @param hint field name.
     * @param r    if true, field will be set read only.
     */
    public DateComponent (Date init,String hint,boolean r) {
	super();
	this.hint = hint;
	readonly = r;
	date = init;
	setupGui();
    }

    //==========================
    // operation
    //==========================

    /** @param d date */
    public void setDate(Date d) {
	date = d;
	updateFromData();
    }

    public Date getDate() {
	updateFromComp();
	return date;
    }

    public boolean isEnabled() {
	return readonly;
    }

    public void setEnabled(boolean t) {
	readonly = t;
	setEditable2(t);
    }

    /** set background color
     * @param c background color
     */
    public void setBackgroundComp(Color c) {
	if (c!=null) {
	    dtext.setBackground(c);
	    ytext.setBackground(c);
	    mtext.setBackground(c);
	}
    }

    //==========================
    // private area
    //==========================

    private void setEditable2(boolean t) {
	dtext.setEditable(t);
	ytext.setEditable(t);
	mtext.setEditable(t);
    }

    JTextField ytext,mtext,dtext;

    void setupGui() {
	setLayout(new FlowLayout(FlowLayout.CENTER));
	
	ytext = new JTextField(4);
	mtext = new JTextField(2);
	dtext = new JTextField(2);
	//
	add(ytext);
	add(new JLabel(CCSResource.getResourceString("Year")));
	add(mtext);
	add(new JLabel(CCSResource.getResourceString("Month")));
	add(dtext);
	add(new JLabel(CCSResource.getResourceString("Date")));
	//
	updateFromData();
    }

    void updateFromData() {
	Calendar cal = Calendar.getInstance();
	if (date != null) {
	    cal.setTime(date);
	    int day = cal.get(cal.DAY_OF_MONTH);
	    int month = cal.get(cal.MONTH)+1;
	    int year = cal.get(cal.YEAR);
	    NumberFormat form = NumberFormat.getInstance();
	    ytext.setText(form.format(year));
	    mtext.setText(form.format(month));
	    dtext.setText(form.format(day));
	} else {
            ytext.setText("----");
            mtext.setText("--");
            dtext.setText("--");
        }
    }

    void updateFromComp() {
	NumberFormat form = NumberFormat.getInstance();
	int day = 0,mon = 0,year = 0;
	String a = null;
	GregorianCalendar calendar = new GregorianCalendar();
	try {
	    //get day
	    String txt = dtext.getText();
	    if (txt == null || txt.indexOf("--") != -1) {
		date = null;
		return;
	    } else {
		a = StringUtil.transform(txt);
		day = form.parse(a).intValue();
	    }
	    //get month
	    txt = mtext.getText();
	    if (txt == null || txt.indexOf("--") != -1) {
		mon = calendar.get(calendar.MONTH);
	    } else {
		a = StringUtil.transform(txt);
		mon = form.parse(a).intValue()-1;
	    }
	    //get year
	    txt = ytext.getText();
	    if (txt == null || txt.indexOf("--") != -1) {
		year = calendar.get(calendar.YEAR);
	    } else {
		a = StringUtil.transform(txt);
		year = form.parse(a).intValue();
	    }
	} catch(ParseException e) {
	    if (a.indexOf("--") != -1) {
		date = null;
		return;
	    }
	    System.err.println(e.getMessage());
	    String [] ss = {hint};
	    String mesf = CCSResource.getResourceString("BadDateField");
	    String mes = MessageFormat.format(mesf,ss);
	    JOptionPane.showMessageDialog(
		this,mes,CCSResource.getResourceString("BadDateField"),
		JOptionPane.ERROR_MESSAGE);
	    date = null;
	    return;
	}
	Calendar cal = Calendar.getInstance();
	cal.clear();
	try {
	    cal.set(year,mon,day);
	} catch (RuntimeException e) {
	    System.err.println(e.getMessage());
	    e.printStackTrace();
	    date = null;
	    return;
	}
	date = cal.getTime();
    }

    /** test */
    public static void main(String [] arg) {
	JFrame f = new JFrame("Date test");
	Container ct = f.getContentPane();
	ct.add(new JLabel("Input date"),"North");
	final DateComponent dc = 
	    new DateComponent(new Date(),"Test date",false);
	ct.add(dc,"Center");
	JButton b = new JButton("exit");
	b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    Date d = dc.getDate();
		    if (d != null) {
			System.out.println(StringUtil.datej(d));
			System.exit(0);
		    }
		}});
	ct.add(b,"South");
	f.pack();
	f.show();
    }

}
