/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.frame;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import java.util.*;


/** Document-View pattern.
  */
public class Document {

    private Vector views;
    private boolean change = false;
    private MessageListener parent;

    /** application constructor.<br>
      * If this document has no view, 
      * document send "fin" message to parent object.
      * @p p "fin" message listener
      */
    public Document(MessageListener p) {
	this();
	parent = p;
    }

    /** default constructor */
    public Document() { views = new Vector(); }

    /** regist a view */
    public synchronized void addView(View v) { views.addElement(v); }

    /** remove a view<br> 
      * if removed last view, send "fin" message to parent.
      */
    public synchronized void removeView(View v) {
	views.removeElement(v);
	if (parent != null) {
	    if (views.size() == 0) {
		parent.message("fin",0,this);
	    }
	}
    }

    /** return views with Enumeration */
    public synchronized Enumeration getViews() { return views.elements(); }

    /** set changed flag */
    public synchronized void changed() { change = true; }

    /** return changed flag */
    public synchronized boolean isChanged() { return change; }

    /** clear changed flag */
    public synchronized void clearChanged() { change = false; }

    /** invoke update routine for all views */
    public void updateViews(Object hint) { updateViews(null,hint); }

    /** invoke update routine for views except the given view */
    public synchronized void updateViews(View v,Object hint) {
	View vv;
	Enumeration e = views.elements();
	while (e.hasMoreElements()) {
	    vv = (View)e.nextElement();
	    if (vv != v) vv.update(hint);
	}
    }
}
