/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.io;
import java.io.*;


/** Easy file reader class */
public class EasyReader extends AbstractReader{

    //======== constructor

    /** Standerd constructor 
      * @param filename the filename which you wanna open as output.
      */
    public EasyReader(String filename) {
	super(openInput(filename));
    }

    //======= private area

    /** low level open method
      * @param filename the filename which you wanna open as output.
      */
    public static BufferedReader openInput(String filename) {
	//error check
	if (filename == null) {
	    System.err.println(" null filename in EasyReader. ");
	    return null;
	}
	if (filename.equals("")) {
	    System.err.println(" null string(\"\") filename in EasyReader. ");
	    return null;
	}
	//open file
	BufferedReader tin=null;
	try {
	    tin = new BufferedReader(new FileReader(filename));
	} catch(IOException e) {
	    System.err.println("I/O Exception was occured in EasyReader.");
	}
	return tin;
    }

    /** test method (usage of this class) */
    public static void main(String [] args) {
	EasyReader file = new EasyReader("test1");
	while (!file.isEOF()) {
	    System.out.println(file.read());
	}
    }
}
