/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.io;
import java.io.*;


/** File System utility class. */
public class FileSystemUtil {

    /** 
     *@param  src source file name.
     *@param  dist distnation file name.
     *@return return true if succeed.
     */
    public static boolean copy(String src,String dist) {
	BufferedInputStream in = null;
	BufferedOutputStream out = null;
	try {
	    in = new BufferedInputStream(
		new FileInputStream(src) );
	    out  = new BufferedOutputStream(
		new FileOutputStream(dist));
	}catch(Exception e) {
	    System.err.println(e.getClass().getName()+"  "+
			       e.getMessage()+"  in FS.copy.");
	    if (in != null)
		try {
		    in.close();
		} catch(Exception ex) {}
	    if (out != null)
		try {
		    out.close();
		}catch(Exception ex) {}
	    return false;
	}
	try {
	    File source = new File(src);
	    long sz = source.length();
	    for(long i = 0;i<sz;i++) {
		out.write(in.read());
	    }
	} catch(IOException e) {
	}
	try {
	    out.flush();
	    out.close();
	    in.close();
	} catch(IOException e) {
	    System.err.println("IOException dring flushing in FS.copy");
	}
	return true;
    }

}
