/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.internet;
import java.applet.*;
import java.awt.*;
import java.net.*;


/**
 * Super class of Sakurai's Applet. This has some utility methods.
 */
public class CCSApplet extends Applet{

    /** goto the page specified given URL. */
    public boolean gotoPage(String page){
	try {
	    URL url = null;
	    if (page.indexOf("http") >= 0) 
		url = new URL(page);
	    else
		url = new URL(getDocumentBase(),page);
	    
	    getAppletContext().showDocument(url);
	    return true;
	} catch (Exception e) {
	    System.err.println(e);
	    return false;
	}
    }

    /** return integer value from applet property
	@param name property name
    */
    public int getInteger(String name) {
        return getInteger(name,0);
    }

    /** return integer value from applet property
	@param name property name
	@param def default value
    */
    public int getInteger(String name,int def) {
	String s;
	s=getParameter(name);
	if (s==null) return def;
	return Integer.parseInt(s);
    }

    /** return real value from applet property
	@param name property name
    */
    public double getDouble(String name) {
        return getDouble(name,0);
    }

    /** return Real value from applet property
	@param name property name
	@param def default value
    */
    public double getDouble(String name,double def) {
	String s;
	s=getParameter(name);
	if (s==null) return def;
	try {
	    return Double.valueOf(s).doubleValue();
	} catch (Exception e) {
	    return def;
	}
    }

    /** return HEX value
	@param name property name
    */
    public int getHex(String name) {
        return getHex(name,"0");
    }

    /** return HEX value from applet property
	@param name property name
	@param def default value
    */
    public int getHex(String name,String def) {
	String value=getString(name,def);
	int intvalue;
	try { intvalue=Integer.parseInt(value,16);}
	catch(NumberFormatException e) {
	    return 0;}
	return intvalue;
    }

    /** return String value from applet property
	@param name property name
    */
    public String getString(String name) {
        return getString(name,"");
    }

    /** return String value from applet property
	@param name property name
	@param def default value
    */
    public String getString(String name,String def) {
	String s;
	s=getParameter(name);
	if (s==null) return def;
	return s;
    }

    /** return Custom font from applet property <br><pre>
	[font]:font name ("SansSerif","Serif","Dialog","Monospaced")
	[large]:the size (about font height)
	[style]:the style (0:plainm, 1:bold, 2:itaric, )
	</pre>
	This method has the default value as ("SnasSerif",24(size),0(plain)).
    */
    public Font getCustomFont() {
      return getCustomFont("SansSerif",24,0);
    }

    /** return Custom font from applet property <br><pre>
	[font]:font name ("SansSerif","Serif","Dialog","Monospaced")
	[large]:the size (about font height)
	[style]:the style (0:plainm, 1:bold, 2:itaric, )
	</pre>
	@param df default font name
	@param dl default font size
	@param ds default font style
    */
    public Font getCustomFont(String df,int dl,int ds) {
	int large = getInteger("large",dl);
	String fontName = getString("font",df);
	int style = 0,pp = getInteger("style",ds);
	if ((pp & 1) != 0) {
	    style += Font.BOLD;
	}
	if ((pp & 2) != 0) {
	    style += Font.ITALIC;
	}
	if (pp==0) {
	    style = Font.PLAIN;
	}
	return new Font(fontName,style,large);
    }
}
