/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.internet;
import java.net.*;
import java.util.*;


/**
  * This class is a static class.
  * So you can use following method directly.
  */

public class LastModified {
    static boolean istest;

    /** this method retruns string presents last modified date like "98/4/4".
      * where : abstract file name or URL
      * ap    : applet object( to get applet dpcument base directory)
      */
    public static String getLastUpdateString(String where, java.applet.Applet ap) {
        String when = "";
	Date date = getLastUpdate(where,ap);
	if (date!=null) {
	    when = Integer.toString(date.getYear());
	    when += "/"+Integer.toString(date.getMonth()+1);
	    when += "/"+Integer.toString(date.getDate());
	    Date curDate = new Date();
	}
	return when;
    }

    /** this method retruns string presents last modified date like "98/4/4".
      * where : perfect URL like "http://www~"
      */
    public static String getLastUpdateString(String where) {
        String when = "";
	Date date = getLastUpdate(where);
	if (date!=null) {
	    when = Integer.toString(date.getYear());
	    when += "/"+Integer.toString(date.getMonth()+1);
	    when += "/"+Integer.toString(date.getDate());
	    Date curDate = new Date();
	}
	return when;
    }

    /** this method retruns last modified date like "98/4/4".
      * where : perfect URL like "http://www~"
      */
    public static Date getLastUpdate(String where) {
	try {
	    URL url;
	    if (where != "") {
		url = new URL(where);
	    	URLConnection uc = url.openConnection();
	    	return new Date(uc.getLastModified()); 
	    } else return null;
	} catch (Exception e) {
	    System.out.println(e);
	    return null;
	}      
    }
    
    /** this method retruns string presents last modified date like "98/4/4".
      * where : any URL string
      * ap    : applet object
      */
    public static Date getLastUpdate(String where,java.applet.Applet ap) {
	try {
	    URL url = null;
	    if (where == "") 
		url = ap.getDocumentBase();
	    else if (where.indexOf("http") >= 0) 
	  	url = new URL(where);
	    else
	  	url = new URL(ap.getDocumentBase(),where);
	    
	    URLConnection uc = url.openConnection();
	    return new Date(uc.getLastModified()); 
	} catch (Exception e) {
	    System.out.println(e);
	    return null;
	}      
    }
}
