/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.awt.Color;


/** Color utility */
public class ColorEditor {

    public static Color getBrighter(Color c) {
	return getMixed(c,Color.white);
    }

    public static Color getDarker(Color c) {
	return getMixed(c,Color.black);
    }

    public static double getBrightness(Color c) {
	return Math.sqrt(c.getRed()*c.getRed()+
			 c.getGreen()*c.getGreen()+
			 c.getBlue()*c.getBlue());
    }
    
    public static double getNorm(Color c) {
	return (c.getRed()*c.getRed()+
		c.getGreen()*c.getGreen()+
		c.getBlue()*c.getBlue());
    }

    public static boolean isBright(Color interestColor, Color comparedColor) {
	return getNorm(interestColor)>getNorm(comparedColor);
    }

    public static Color getBrighter(Color c1, Color c2) {
	return (getNorm(c1)>getNorm(c2)) ? c1 : c2;
    }    

    public static Color getMixed(Color c1,Color c2) {
	int r1,r2,g1,g2,b1,b2;
	r1 = c1.getRed();
	g1 = c1.getGreen();
	b1 = c1.getBlue();
	r2 = c2.getRed();
	g2 = c2.getGreen();
	b2 = c2.getBlue();
	return new Color((r1+r2)>>1,(g1+g2)>>1,(b1+b2)>>1);
    }

    
}
