/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.awt.*;


/** make color index */
public class ColorSet {

    // geographics color set
    public static Color [] geographIndex = 
           {new Color(0xcc00cc), Color.blue, Color.cyan,
	    Color.yellow, Color.green, Color.red};

    // rainbow color set
    public static Color [] rainbowIndex = 
           {new Color(0xcc00cc),Color.blue,
	    Color.green,Color.yellow,Color.orange,Color.red};


    protected Color [] index;
    boolean rev=false;

    /**
     *@param zeroc color of first index
     *@param endc  color of last index
     *@param num   number of index
     */
    public ColorSet(Color zeroc,Color endc,int num) {
	index = makeColorIndex(zeroc,endc,num);
    }

    /**
     *@param colors color index 
     *              (you can use "geographIndex" or "rainbowIndex")
     *@param num   number of index
     */
    public ColorSet(Color [] colors, int num) {
	index = makeColorIndex(colors,num);
    }

    /** make gradation color index. */
    public static Color[] makeColorIndex(Color zeroc,Color endc,int num) {
	int forColor = zeroc.getRGB();
	int backColor = endc.getRGB();
	int br,bg,bb,cc;
	double fr,fg,fb;
	br = (backColor>>16)&255;
	bg = (backColor>>8)&255;
	bb = backColor&255;
	fr = (forColor>>16)&255;
	fg = (forColor>>8)&255;
	fb = forColor&255;
	
	Color [] colorIndex = new Color [num];
	for (int i=0; i<num; i++) {
	    cc = backColor + ((int)((fr-br)*i/num))*65536+
		((int)((fg-bg)*i/num))*256+
		((int)((fb-bb)*i/num));
	    colorIndex[i] = new Color(cc);
	}
	return colorIndex;
    }

    /**  make gradation color index */
    public static Color[] makeColorIndex(Color [] set,int num) {
	Color [] colorIndex = new Color [num];
	double vc,rh,rl;
	Color low,hi;
	int cc,ivc;
	double fr,fg,fb,br,bg,bb;
	for (int i=0; i<num; i++) {
	    vc = ((double)(set.length-1)/num)*i;
	    ivc = (int)vc;
	    low = set[ivc];
	    hi = set[ivc+1];
	    rh = vc-ivc;
	    rl = 1.-rh;
	    br = low.getRed();
	    bg = low.getGreen();
	    bb = low.getBlue();
	    fr = hi.getRed();
	    fg = hi.getGreen();
	    fb = hi.getBlue();
	    cc = (int)(br*rl+fr*rh)*65536+(int)(bg*rl+fg*rh)*256+
		 (int)(bb*rl+fb*rh);
	    colorIndex[i] = new Color(cc);
	}
	return colorIndex;
    }


    public void setReversible(boolean b){rev= b;}

    /**
     * @param i color index number
     * @return suitable color
     */
    public Color getColor(int i) {
	if (i < 0)  
	    if (rev)
		i=-i;
	    else
		i = 0;
	if (index.length <= i) i = index.length-1;
	return index[i];
    }

    /**
     * @param d input value (0.0 <= d <= 1.0)
     * @return suitable color
     */
    public Color getColor(double d) {
	return getColor((int)Math.rint(d*index.length));
    }
}
