/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;


/** 
 *  [<code>ComparableClass</code>]<br>
 *  
 *  this class is used to compare something to sort.
 * (For JDK11)
 */ 

public abstract class ComparableClass implements jp.gr.java_conf.ccs2.util.Comparable {

    /**
     * [<code>greaterThan</code>]
     *  
     *  
     * @param com some comparable object
     * @return the result you decided
     */ 
    final public boolean greaterThan(Comparable com){
	return (getValue() > ((ComparableClass)com).getValue());
    }

    final public boolean equals(Comparable com) {
	return (getValue() == ((ComparableClass)com).getValue());
    }

    public abstract double getValue();


    //quick sort2 (From FwCɂŐVASYTx)

    private static int THRESHOLD = 10;
    private static int STACKSIZE = 32;

    private static void inssort(Comparable [] a){
	Comparable x;
	int n = a.length,i,j;
	for (i = 1; i < n; i++) {
	    x = a[i];
	    for (j = i - 1; j >= 0 && x.greaterThan(a[j]); j--)
		a[j + 1] = a[j];
	    a[j + 1] = x;
	}
    }

    /**
       Sort utility
     */
    public static void qsort(Comparable [] a) {
	int n = a.length;
	int i, j, left, right, p;
	int [] leftstack = new int [STACKSIZE];
	int [] rightstack = new int [STACKSIZE];
	Comparable x, t;
	
	left = 0;  right = n - 1;  p = 0;
	for ( ; ; ) {
	    if (right - left <= THRESHOLD) {
		if (p == 0) break;
		p--;
		left = leftstack[p];
		right = rightstack[p];
	    }
	    x = a[(left + right) / 2];
	    i = left;  j = right;
	    for ( ; ; ) {
		while (a[i].greaterThan(x) && i<right) i++;
		while (x.greaterThan(a[j]) && j>left) j--;
		if (i >= j) break;
		t = a[i];  a[i] = a[j];  a[j] = t;
		i++;  j--;
	    }
	    if (i - left > right - j) {
		if (i - left > THRESHOLD) {
		    leftstack[p] = left;
		    rightstack[p] = i - 1;
		    p++;
		}
		left = j + 1;
	    } else {
		if (right - j > THRESHOLD) {
		    leftstack[p] = j + 1;
		    rightstack[p] = right;
		    p++;
		}
		right = i - 1;
	    }
	}
	inssort(a);
    }
}
