/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.sql.*;
import java.io.Serializable;

public class ConnectionBean implements Serializable {

    String url,driver;
    boolean driverExist = false;
    transient Connection connection;
    
    public ConnectionBean() {
    }

    public ConnectionBean(String dr,String u) {
	setDriver(dr);
	setUrl(u);
    }

    public ConnectionBean(Connection c) {
	setConnection(c);
    }

    public void setConnection(Connection c) {
	driverExist = true;
	connection = c;
    }
    public void setUrl(String u) {url = u;}
    public String getUrl() {return url;}
    public void setDriver(String d) {
	driver = d;
	driverExist = JDBCUtil.registDriver(driver);
    }
    public String getDriver() {return driver;}

    public Connection getConnection() throws SQLException {
	if (!driverExist) {
	    throw new RuntimeException("Driver ["+driver+"] doesn't exist!");
	}
	if (connection == null || connection.isClosed()) {
	    connection = DriverManager.getConnection(url);
	}
	return connection;
    }
    
    public void closeConnection() {
	try {
	    if (connection != null)
		connection.close();
	} catch (SQLException e) {
	    System.err.println("SQLException : "+e.getMessage() +" in ConnectionBean.");
	    //e.printStackTrace();
	}
    }

    protected void finalize() {
	closeConnection();
    }
}
