/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.awt.*;
import java.awt.image.*;


/**
  * this class edits images
  * usage:<br>
	<code>
	(forground : forground image, background : background image)
	ImageEditor im = new ImageEditor();
	Image mix = im.compoundImage(forground,backgorund,0,0xffffff);
	</code>
  */

public class ImageEditor extends Component{

    int forColor,backColor;

    /**
      * this class need ImageObserver
      */
    public ImageEditor() {
    }

    /**
      * "imgf" is forground image and "imgr" is background image.<br>
      * if the pixel color of "imgf" is near "forColor", will be active.<br>
      * if the oixel color of "imgf" is near "backColor", will be transparent.<br>
      * 
      * @param imgf forground image
      * @param imgb background image
      * @param forColor the most active color
      * @param backColor transparent color
      * @return mixed image
      */
    public Image compoundImage(Image imgf,Image imgr,
			       int forColor, int backColor) {
	this.forColor = forColor;
	this.backColor = backColor;
	if (imgr == null || imgf == null) return null;
	
	int rwidth,rheight,width,height;
	width = imgf.getWidth(this);
	height = imgf.getHeight(this);
	rwidth = imgr.getWidth(this);
	rheight = imgr.getHeight(this);
	if (rwidth>width) rwidth = width;
	if (rheight>height) rheight = height;
	
	int[] pix = new int[width * height];
	int[] pos = new int[rwidth * rheight];
	boolean ret;
	PixelGrabber pg = 
	    new PixelGrabber(imgf, 0, 0,width, height, pix, 0, width);
	PixelGrabber pg2 = 
	    new PixelGrabber(imgr, 0, 0,rwidth, rheight, pos, 0, rwidth);
	try {
	    ret = pg.grabPixels(1000);
	} catch (Throwable e) {
	    System.err.println("forground image time out !");
	}
	try {
	    ret = pg2.grabPixels(1000);
	} catch (Throwable e) {
	    System.out.println("background image time out !");
	}
	int index,ipx;
	for (int i = 0; i < width; i++) {
	    for (int j = 0;j<height; j++) {
		index = i+width*j;
		ipx = i%rwidth + rwidth*(j%rheight);
		pix[index] = filter(pix[index],pos[(ipx)]);
	    }
	}
	return this.createImage(new MemoryImageSource(width,height,pix,0,width));
    }
    
    // transparent function.
    // rgb:pixel of "imgr"  pic:pixel of "imgr"
    protected int filter(int rgb, int pic) {
	if ( (rgb&0xffffff) == forColor) {
	    return rgb;
	}
	if ( (rgb&0xffffff) == backColor) {
	    return pic;
	}
	rgb &= 0xffffff;
	pic &= 0xffffff;

	int br,bg,bb,cc,fr,fg,fb;
	int pr,pg,pb,tr,tb,tg;
	double depth;
	br = ((int)(backColor/65536))%256;
	bg = ((int)(backColor/256))%256;
	bb = backColor%256;
	pr = ((int)(pic/65536))%256;
	pg = ((int)(pic/256))%256;
	pb = pic%256;
	fr = ((int)(forColor/65536))%256;
	fg = ((int)(forColor/256))%256;
	fb = forColor%256;
	tr = ((int)(rgb/65536))%256;
	tg = ((int)(rgb/256))%256;
	tb = rgb%256;
	depth = Math.sqrt((tr-br)*(tr-br)+(tg-bg)*(tg-bg)+(tb-bb)*(tb-bb))/
	    Math.sqrt((fr-br)*(fr-br)+(fg-bg)*(fg-bg)+(fb-bb)*(fb-bb));
	cc =((int)(pr+(tr-pr)*depth))*65536+
	    ((int)(pg+(tg-pg)*depth))*256+
	    ((int)(pb+(tb-pb)*depth))+0xff000000;
	return cc;
    }
}
