/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;

import java.sql.*;
import java.util.ArrayList;
import jp.gr.java_conf.ccs2.util.StringUtil;
import java.util.Map;

/**
   <code>JDBCUtil</code> has some utilities to connect and handle 
   a DB source. 
  
   [for Java2]

   @author SAKURAI Masashi
 */

public class JDBCUtil {

    public static boolean registDriver(String driverClassName) {
	try {
	    Class.forName(driverClassName).newInstance(); 
	    return true;
	}
	catch (Exception e) {
	    System.err.println("Unable to load driver ["+driverClassName+"].");
	    e.printStackTrace();
	}
	return false;
    }

    public static SQLException closeConnection(Connection con) {
	try {
	    if (con != null)
		con.close();
	} catch (SQLException ex) {
	    return ex;
	}
	return null;
    }
    

    //===================================
    // Query
    //===================================
    
    public static ResultSet getResultSet(Connection con,String sql) throws SQLException {
	Statement stmt = null;
        try {
	    stmt = con.createStatement();
	    ResultSet set = stmt.executeQuery(sql);
            return set;
        } finally {
	    if (stmt != null)
		stmt.close();
	}
    }

    public static ResultSet getResultSet(String url,String sql) throws SQLException {
	Connection con = null;
        try {
	    con = DriverManager.getConnection(url);
	    return getResultSet(con,sql);
        } finally {
	    if (con != null)
		con.close();
	}
    }

    public static String getResult(Connection con,String sql) throws SQLException {
	ResultSet set = getResultSet(con,sql);
	if (set == null) return null;
	if (!set.next()) return null;
	return esc(set.getString(1));
    }

    public static String getResult(String url,String sql) throws SQLException {
	ResultSet set = getResultSet(url,sql);
	if (set == null) return null;
	if (!set.next()) return null;
	return esc(set.getString(1));
    }

    //===================================
    // Layout Data
    //===================================
    
    public static String CTRL = "%";

    public static String [] layoutData(String layout,ResultSet rs) throws SQLException {
	return layoutData(layout,rs,null);
    }

    public static String [] layoutData(String layout,
				       ResultSet rs,
				       Map map) throws SQLException {
	if (StringUtil.isNull(layout)) return null;
	if (rs == null) return clearLayoutDatas(layout);
	String [] columnNames = makeColumnArray(rs);
	String [] rets = new String[getRowNumber(rs)];
	for (int row=0;rs.next();row++) {
	    String line = layout;
	    for (int i=0;i<columnNames.length;i++) {
		String data = esc(rs.getString(i+1));
		if (map != null) {
		    StringTransformer tr = 
			(StringTransformer)map.get(columnNames[i]);
		    if (tr != null) {
			data = tr.transform(data);
		    }
		}
		line = StringUtil.replace(
		    line,columnCtrlCode(columnNames[i]),data);
	    }
	    rets[row] = line;
	}
	return rets;
    }

    private static String columnCtrlCode(String clmName) {
	return CTRL+clmName+CTRL;
    }

    static String [] makeColumnArray(ResultSet rs) throws SQLException {
	ResultSetMetaData rsmd = rs.getMetaData();
	int cols = rsmd.getColumnCount();
	String [] columnNames = new String[cols];
	for (int i=0;i<cols;i++) {
	    columnNames[i] = rsmd.getColumnName(i+1);
	}
	return columnNames;
    }

    static String [] clearLayoutDatas(String in) {
	String [] ret = {clearLayoutData(in)};
	return ret;
    }

    static String clearLayoutData(String in) {
	StringBuffer ret = new StringBuffer();
	while (true) {
	    int ps = in.indexOf(CTRL);
	    if (ps == -1) break;
	    ret.append(in.substring(0,ps));
	    in = in.substring(ps+1);
	    int pe = in.indexOf(CTRL);
	    if (pe == -1) break;
	    in = in.substring(pe+1);
	}
	ret.append(in);
	return ret.toString();
    }

    public static int getRowNumber(ResultSet rs) throws SQLException {
	if (rs == null) return 0;
	rs.last();
	int cc = rs.getRow();
	rs.beforeFirst();
	return cc;
    }

    public static String esc(String in) {
	if (sjisEscape) return StringUtil.sjisEscape(in);
	return in;
    }

    public static boolean sjisEscape = true;

    //===================================
    // Lock tables
    //===================================

    public static void lockTables(Statement stmt,
				  String [] tables,
				  boolean [] isWrite) throws SQLException {
	if (tables == null || tables.length==0) return;
	for (int i=0;i<tables.length;i++) {
	    
	}
	stmt.execute("LOCK TABLES ");
    }

    public static void unlockTables(Statement stmt) throws SQLException {
	
    }
}
