package jp.gr.java_conf.ccs2.util;

import java.sql.*;
import jp.gr.java_conf.ccs2.util.*;
import junit.framework.TestCase;
import java.util.HashMap;
import java.util.Map;

public class JDBCUtilTest extends TestCase {

    public JDBCUtilTest(String a) {
	super(a);
    }

    ConnectionBean cb;

    public void setUp() {
	String url = "jdbc:mysql://leon/ss2001?user=sakurai&password=carol&useUnicode=true&characterEncoding=EUCJIS";
	cb = new ConnectionBean("org.gjt.mm.mysql.Driver",url);
    }

    public void tearDown() {
	cb.closeConnection();
    }

    public void testClear() {
	String in = "<td>%name%</td><td class=\"%fire arms%\">%BBC%</td>";
	String test = JDBCUtil.clearLayoutData(in);
	String ans = "<td></td><td class=\"\"></td>";
	assertEquals("Clear",ans,test);
    }

    public void testQueryBean() {
	String sql = "SELECT address.num,name,loginname,lastlogin FROM address "+
	    "INNER JOIN login ON address.num=login.num "+
	    "WHERE address.num = 5";
	QueryBean da = new QueryBean(cb,sql);
	da.setLayout("(%num%) %name% : %loginname%");
	try {
	    String [] rets = da.layoutResultSet();
	    assert("same?",StringUtil.assertEquals(rets[0],"(5)  j : sakurai"));
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public void testInterrupt() {
	String sql = 
	    "SELECT num,loginname,lastlogin,lastlogin login2 FROM login "+
	    "WHERE num = 5";
	QueryBean da = new QueryBean(cb,sql);
	da.setLayout("%lastlogin% : %login2%");
	Map map = new HashMap();
	map.put("lastlogin",new Time2DateTransformer());
	map.put("login2",new IntNumberTransformer());
	try {
	    String [] test = da.layoutResultSet(map);
	    //
	    ResultSet rs = da.getResultSet();
	    rs.next();
	    String ans = new Time2DateTransformer().transform(rs.getString("lastlogin"));
	    ans += " : ";
	    ans += new IntNumberTransformer().transform(rs.getString("login2"));
	    assert("same?",StringUtil.assertEquals(test[0],ans));
	} catch (Exception e) {
	    e.printStackTrace();
	}

    }

}
