/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.util.*;
import java.text.*;


/** String utility */
public class StringUtil {

    static DateFormat ftj_date = DateFormat.getDateInstance(DateFormat.FULL);
    static DateFormat ftj_datetime = DateFormat.getDateTimeInstance(DateFormat.FULL,DateFormat.FULL);
    static DateFormat ftl_date = DateFormat.getDateInstance(DateFormat.MEDIUM);
    static DateFormat ftl_datetime = DateFormat.getDateTimeInstance(DateFormat.MEDIUM ,DateFormat.MEDIUM );

    /** full format the date object with long date type */
    public static String datej(Date d) {
	if (d == null) return "";
	return ftj_date.format(d);
    }

    /** full format the date object with long date-time type */
    public static String dateTimej(Date d) {
	if (d == null) return "";
	return ftj_datetime.format(d);
    }

    /** long format the date object with long date type */
    public static String datel(Date d) {
	if (d == null) return "";
	return ftl_date.format(d);
    }

    /** long format the date object with long date-time type */
    public static String dateTimel(Date d) {
	if (d == null) return "";
	return ftl_datetime.format(d);
    }

    /** if (s == null || s.length == 0) return true; */
    public static final boolean isNull(String s) {
	if (s == null || s.length() == 0) return true;
	return false;
    }

    public static final boolean assertEquals(String a,String b) {
	if (a.equals(b)) return true;
	int rows = 0,cols = 0;
	int nori = 16;
	for (int i=0; i<a.length();i++) {
	    if (a.charAt(i) != b.charAt(i)) {
		String message = "{0}[{1}]{2}";
		Object [] args1 = {
		    a.substring(Math.max(0,i-nori),i),
		    a.substring(i,i+1),
		    a.substring(i+1,Math.min(a.length(),i+nori))
		};
		String ret = "ASSERT String rows["+rows+"] cols["+cols+"]:\n"+
		    MessageFormat.format(message,args1);
		Object [] args2 = {
		    b.substring(Math.max(0,i-nori),i),
		    b.substring(i,i+1),
		    b.substring(i+1,Math.min(b.length(),i+nori))
		};
		ret += "\n"+MessageFormat.format(message,args2);
		throw new RuntimeException(ret);
	    }
	    if (a.charAt(i)=='\n') {
		cols = 0; rows ++;
	    } else 
		cols++;
	}
	return false;
    }

    public static String conbine(String [] ss) {
	return conbine(ss,"");
    }

    public static String conbine(String [] ss,String spliter) {
	StringBuffer ret = new StringBuffer();
	for (int i=0;i<ss.length;i++) 
	    ret.append(ss[i]).append(spliter);
	return ret.toString();
    }

    /** split given string by space, tab, return or comma */
    public static String [] split(String arg) {
	return split(arg,null);
    }

    /** split given string by given delimiter 
	@param arg input text
	@param dlm one character
	@return splitted text
     */
    public static String [] split(String arg,String dlm) {
	String [] rets = null;
	if (arg == null) return null;
	if (arg.length() == 0) {
	     rets = new String[1];
	     rets[0] = "";
	     return rets;
	}

	//my custom splitter
	if (dlm != null) {
	    Vector list = new Vector();
	    int skip = dlm.length();
	    int sx = 0;
	    while(true) {
		int ps = arg.indexOf(dlm,sx);
		if (ps == 0) {
		    //null contents
		    list.addElement("");
		} else if (ps == -1) {
		    //end of contents
		    list.addElement(arg);
		    break;
		} else if (arg.charAt(ps-1) == '\\') {
		    //escaping delimiter
		    String tmp = arg.substring(0,ps-1)+arg.substring(ps);
		    sx = ps + skip-1;
		    arg = tmp;
		    continue;
		} else {
		    //normal contents
		    list.addElement( arg.substring(0,ps) );
		}
		arg = arg.substring(ps+skip);
		sx = 0;
	    }
	    rets = new String[list.size()];
	    for(int i=0;i<rets.length;i++) {
		rets[i] = ((String)list.elementAt(i)).trim();
	    }
	    return rets;
	}

	//throw into StringTokenizer
	StringTokenizer st = null;
	if (dlm == null) st = new StringTokenizer(arg);
	else st = new StringTokenizer(arg,dlm);

	rets = new String[st.countTokens()];
	for(int i=0;i<rets.length;i++) {
	    rets[i] = st.nextToken();
	}
	return rets;
    }

    /** Replace substring
	@param in Original string
	@param in target word
	@param in replace word
	@return replaced string
    */
    public static String replace(String in,String target,String after) {
	if (in == null) return "";
	StringBuffer out = new StringBuffer();
	while(true) {
	    int ps = in.indexOf(target);
	    if (ps == -1) {
		out.append( in.toString() );
		break;
	    }
	    out.append( in.substring(0,ps) );
	    out.append( after );
	    in = in.substring( ps+target.length() );
	}
	return out.toString();
    }

    /** Transform from ZENKAKU to HANKAKU <br>
	See [sakrai.lang.zenkaku]
	@param in original string
	@return transformed string
     */
    public static String transform(String in) {
	if (in == null) return null;
	String zenkaku = getResourceString("zenkaku");
	String hankaku = getResourceString("hankaku");
	StringBuffer ret = new StringBuffer();
	for(int i=0;i<in.length();i++) {
	    String a = in.substring(i,i+1);
	    int ps = zenkaku.indexOf(a);
	    if (ps == -1) 
		ret.append(a);
	    else 
		ret.append(hankaku.substring(ps,ps+1));
	}
	return ret.toString();
    }

    public static String sjisEscape(String in) {
	in = replace(in,"\u301c","\uFF5E");//`
	//in = replace(in,"`","\uFF5E");
	//in = replace(in,"\","\\u2015");
	//in = replace(in,"~", "\u007E");
	//in = replace(in,"","\uFFE5");
	//in = replace(in,"P","\uFFE3");
	//in = replace(in,"_","\uFF3C");
	in = replace(in,"\u2016","\u2225");//a
	in = replace(in,"\u2212","\uFF0D");//|
	return in;
    }

    public static String stringDump(String in) {
	StringBuffer sb = new StringBuffer();
	for (int i=0;i<in.length();i++) {
	    char c = in.charAt(i);
	    sb.append(c).append(" : ");
	    sb.append(
		Integer.toHexString((int)c));
	    sb.append("\n");
	}
	return sb.toString();
    }

    //====================================
    // private area
    //====================================

    public static void main(String [] args) {
	assertEquals(transform(
	    "This is a pen which h had.\nThank you ery muhD"),
		     "This is a pen which I had.\nThank you very much.");
    }

    private static ResourceBundle resources;
    private static boolean loadFailed = false;

    /** loading a transfer resource file [zenkaku] */
    private static void loadResources() {
	try {
	    resources = ResourceBundle.getBundle("jp.gr.java_conf.ccs2.util.zenkaku");
	} catch (MissingResourceException mre) {
	    System.err.println("[strings.properties] not found");
	    loadFailed = true;
	}
    }
 
    /** get resource string from properties file "strings.properties" */
    private  static String getResourceString(String s) {
	if (resources == null && !loadFailed) 
	    loadResources();
	try {
	    return resources.getString(s);
	} catch (RuntimeException e) {
	    System.err.println("no string :"+s);
	}
	return s;
    }

}
