/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.util.*;


/** this class provides a timer to send message
 * once or every time at set time. 
 * See main method to know this usage.
 * (For JDK11)
 */

public class Timer implements Runnable {

    protected int interval;
    protected Vector listeners = new Vector();
    protected boolean once = false;

    protected Caller caller = new Caller();
    protected Thread thread;
    
    protected boolean exit = false;
    private boolean late = false;

    //=============================
    // constructor
    //=============================

    /** each time timer
      * @param timerListener TimerListner object
      * @param i interval time (m sec)
      */
    public Timer(TimerListener timerListener,int i) {
	interval = i;
	addTimerListener(timerListener);
    }

    /** custom timer
      * @param timerListener TimerListner object
      * @param i interval time (m sec)
      * @param once if true, this sends message only once.
      */
    public Timer(TimerListener timerListener,int i,boolean once) {
	interval = i;
	addTimerListener(timerListener);
	this.once = once;
    }

    //=============================
    // operation
    //=============================

    public void addTimerListener(TimerListener t) {
	listeners.addElement(t);
    }

    public void removeTimerListener(TimerListener t) {
	listeners.removeElement(t);
    }

    public void removeAllTimerListener() {
	listeners.removeAllElements();
    }
    
    public void setInterval(int i) {
	interval = i;
    }

    public int getInterval() {return interval;}

    public void startTimer() {
	thread = new Thread(this);
	thread.start();
    }

    /** the same as [finish()] */
    public void stopTimer() {
	finish();
    }

    /** exit timer */
    public void finish() {
	exit = true;
    }

    //=============================
    // operation
    //=============================

    final private void invoke() {
	Thread t = new Thread(caller);
	t.start();
    }

    final private void sleep() {
	try {
	    thread.sleep(interval);
	} catch(InterruptedException e) {
	    System.out.println("interrupted...");
	}
    }

    /** start the timer */
    public void run() {
	exit = false;
	if (once) {
	    sleep();
	    invoke();
	    return;
	}

	while(!exit) {
	    sleep();
	    if (!caller.isWorking()) {
		invoke();
	    } else {
		if (!late) {
		    System.out.println(
				       "CPU doesn't catch up with your work.");
		    late = true;//once message
		}
	    }
	}
    }
    
    class Caller implements Runnable {
	
	boolean working=false;

	synchronized boolean isWorking() { return working;}
	synchronized void setWorking(boolean b) { working = b;}

	public void run() {
	    setWorking(true);

	    Enumeration e = listeners.elements();
	    while(e.hasMoreElements()) {
		((TimerListener)e.nextElement()).goodMorning();
	    }

	    setWorking(false);
	}
    }

    /**
     * Easy implementation of Timer and TimerListener
     */
    public static void main(String [] arg) {
	Timer timer = new Timer(new TimerListener() {
	    int a=0;
	    public void goodMorning() {
		a+=100;
		System.out.println("time!  : "+a);
	    }
	},100);
	timer.startTimer();
    }

}

