/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jp.gr.java_conf.ccs2.comp.RectPainter;

public class BufferedCanvas
extends JComponent {
    protected Graphics backGraphics = null;
    protected Image backImage = null;
    protected Dimension size = null;
    protected RectPainter bgPainter = null;
    protected boolean heavyContents = false;
    protected boolean needsUpdate = false;
    private boolean whole = false;

    public BufferedCanvas() {
        this.setBackground(Color.white);
    }

    public void setBackground(RectPainter rectPainter) {
        this.bgPainter = rectPainter;
    }

    public void setRectPainter(RectPainter rectPainter) {
        this.bgPainter = rectPainter;
    }

    public RectPainter getRectPainter() {
        return this.bgPainter;
    }

    public Dimension getSize() {
        if (this.size == null) {
            this.size = super.getSize();
        }
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void setHeavyContents(boolean bl) {
        this.heavyContents = bl;
        this.needsUpdate = true;
    }

    public void repaint() {
        this.needsUpdate = true;
        super.repaint();
    }

    public final void paint(Graphics graphics) {
        if (this.backImage == null) {
            this.fillBackground(graphics);
        }
        if (this.heavyContents && !this.needsUpdate) {
            graphics.drawImage(this.backImage, 0, 0, this);
            return;
        }
        Graphics graphics2 = this.getBackGraphics();
        this.fillBackground(graphics2);
        this.bpaint(graphics2);
        graphics.drawImage(this.backImage, 0, 0, this);
        if (this.whole) {
            this.whole = false;
            this.repaint();
        }
    }

    public void bpaint(Graphics graphics) {
        if (this.bgPainter == null) {
            Dimension dimension = this.getSize();
            int n = 10;
            graphics.drawRect(n, n, dimension.width - n * 2, dimension.height - n * 2);
            graphics.drawString("(" + dimension.width + " - " + dimension.height + ")", n * 2, n * 2);
        }
    }

    private Graphics getBackGraphics() {
        Dimension dimension = super.getSize();
        if (this.backImage == null || !dimension.equals(this.size)) {
            this.size.width = dimension.width;
            this.size.height = dimension.height;
            this.backImage = this.createImage(dimension.width, dimension.height);
            this.backGraphics = this.backImage.getGraphics();
            this.whole = true;
            return this.backGraphics;
        }
        return this.backGraphics;
    }

    private void fillBackground(Graphics graphics) {
        Color color = graphics.getColor();
        Dimension dimension = this.getSize();
        if (this.bgPainter == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        } else {
            this.bgPainter.paint(graphics, new Rectangle(0, 0, dimension.width, dimension.height));
        }
        graphics.setColor(color);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("buffered canvas test");
        jFrame.getContentPane().add(new BufferedCanvas());
        ((Component)jFrame).setSize(500, 400);
        jFrame.show();
    }
}

