/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.gr.java_conf.ccs2.core.CCSResource;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class DateComponent
extends JPanel {
    Date date;
    String hint;
    boolean readonly = false;
    JTextField ytext;
    JTextField mtext;
    JTextField dtext;

    public DateComponent() {
        this((String)null);
    }

    public DateComponent(String string) {
        this(new Date(), string, false);
    }

    public DateComponent(Date date, String string, boolean bl) {
        this.hint = string;
        this.readonly = bl;
        this.date = date;
        this.setupGui();
    }

    public void setDate(Date date) {
        this.date = date;
        this.updateFromData();
    }

    public Date getDate() {
        this.updateFromComp();
        return this.date;
    }

    public boolean isEnabled() {
        return this.readonly;
    }

    public void setEnabled(boolean bl) {
        this.readonly = bl;
        this.setEditable2(bl);
    }

    public void setBackgroundComp(Color color) {
        if (color != null) {
            this.dtext.setBackground(color);
            this.ytext.setBackground(color);
            this.mtext.setBackground(color);
        }
    }

    private void setEditable2(boolean bl) {
        this.dtext.setEditable(bl);
        this.ytext.setEditable(bl);
        this.mtext.setEditable(bl);
    }

    void setupGui() {
        this.setLayout(new FlowLayout(1));
        this.ytext = new JTextField(4);
        this.mtext = new JTextField(2);
        this.dtext = new JTextField(2);
        this.add(this.ytext);
        this.add(new JLabel(CCSResource.getResourceString("Year")));
        this.add(this.mtext);
        this.add(new JLabel(CCSResource.getResourceString("Month")));
        this.add(this.dtext);
        this.add(new JLabel(CCSResource.getResourceString("Date")));
        this.updateFromData();
    }

    void updateFromData() {
        Calendar calendar = Calendar.getInstance();
        if (this.date != null) {
            calendar.setTime(this.date);
            int n = calendar.get(5);
            int n2 = calendar.get(2) + 1;
            int n3 = calendar.get(1);
            NumberFormat numberFormat = NumberFormat.getInstance();
            this.ytext.setText(numberFormat.format(n3));
            this.mtext.setText(numberFormat.format(n2));
            this.dtext.setText(numberFormat.format(n));
        } else {
            this.ytext.setText("----");
            this.mtext.setText("--");
            this.dtext.setText("--");
        }
    }

    void updateFromComp() {
        Object object;
        NumberFormat numberFormat = NumberFormat.getInstance();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            object = this.dtext.getText();
            if (object == null || ((String)object).indexOf("--") != -1) {
                this.date = null;
                return;
            }
            string = StringUtil.transform((String)object);
            n = numberFormat.parse(string).intValue();
            object = this.mtext.getText();
            if (object == null || ((String)object).indexOf("--") != -1) {
                n2 = gregorianCalendar.get(2);
            } else {
                string = StringUtil.transform((String)object);
                n2 = numberFormat.parse(string).intValue() - 1;
            }
            object = this.ytext.getText();
            if (object == null || ((String)object).indexOf("--") != -1) {
                n3 = gregorianCalendar.get(1);
            } else {
                string = StringUtil.transform((String)object);
                n3 = numberFormat.parse(string).intValue();
            }
        }
        catch (ParseException parseException) {
            if (string.indexOf("--") != -1) {
                this.date = null;
                return;
            }
            System.err.println(parseException.getMessage());
            Object[] objectArray = new String[]{this.hint};
            String string2 = CCSResource.getResourceString("BadDateField");
            String string3 = MessageFormat.format(string2, objectArray);
            JOptionPane.showMessageDialog(this, string3, CCSResource.getResourceString("BadDateField"), 0);
            this.date = null;
            return;
        }
        object = Calendar.getInstance();
        ((Calendar)object).clear();
        try {
            ((Calendar)object).set(n3, n2, n);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(runtimeException.getMessage());
            runtimeException.printStackTrace();
            this.date = null;
            return;
        }
        this.date = ((Calendar)object).getTime();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Date test");
        Container container = jFrame.getContentPane();
        container.add((Component)new JLabel("Input date"), "North");
        final DateComponent dateComponent = new DateComponent(new Date(), "Test date", false);
        container.add((Component)dateComponent, "Center");
        JButton jButton = new JButton("exit");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Date date = dateComponent.getDate();
                if (date != null) {
                    System.out.println(StringUtil.datej(date));
                    System.exit(0);
                }
            }
        });
        container.add((Component)jButton, "South");
        jFrame.pack();
        jFrame.show();
    }
}

