/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import jp.gr.java_conf.ccs2.comp.RectPainter;

public class ImagePainter
extends RectPainter {
    public static final int CENTER = 0;
    public static final int FILL = 1;
    public static final int FIT = 2;
    public static final int LEFTTOP = 3;
    protected Image image;
    protected int type = 0;
    protected ImageObserver parent;

    public ImagePainter(Image image, int n, ImageObserver imageObserver) {
        this.image = image;
        this.type = n;
        this.parent = imageObserver;
    }

    public ImagePainter(String string, int n, ImageObserver imageObserver) {
        this.loadImage(string);
        this.type = n;
        this.parent = imageObserver;
    }

    public ImagePainter(Image image, ImageObserver imageObserver) {
        this(image, 0, imageObserver);
    }

    public ImagePainter(String string, ImageObserver imageObserver) {
        this(string, 0, imageObserver);
    }

    private void loadImage(String string) {
        try {
            this.image = Toolkit.getDefaultToolkit().getImage(string);
        }
        catch (Exception exception) {
            System.err.println(exception.getClass().getName() + " : " + exception.getMessage());
            System.err.println("Cannot load image. [" + string + "]");
        }
    }

    public void setImage(String string) {
        this.loadImage(string);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void filter(Color color) {
        ColoredFilter coloredFilter = new ColoredFilter(color);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.image.getSource(), coloredFilter);
        this.image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void work(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = this.image.getWidth(this.parent);
        int n4 = this.image.getHeight(this.parent);
        switch (this.type) {
            case 1: {
                if (n3 <= 0) return;
                if (n4 <= 0) {
                    return;
                }
                block5: while (true) {
                    if (n2 >= rectangle.height + rectangle.y) {
                        return;
                    }
                    n = rectangle.x;
                    while (true) {
                        if (n >= rectangle.width + rectangle.x) {
                            n2 += n4;
                            continue block5;
                        }
                        graphics.drawImage(this.image, n, n2, this.parent);
                        n += n3;
                    }
                    break;
                }
            }
            case 2: {
                graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.parent);
                return;
            }
            case 3: {
                graphics.drawImage(this.image, rectangle.x, rectangle.y, this.parent);
                return;
            }
        }
        n = rectangle.width - n3 >> 1;
        n2 = rectangle.height - n4 >> 1;
        graphics.drawImage(this.image, rectangle.x + n, rectangle.y + n2, this.parent);
    }

    class ColoredFilter
    extends RGBImageFilter {
        int rr;
        int gg;
        int bb;

        public ColoredFilter(Color color) {
            this.canFilterIndexColorModel = true;
            this.rr = color.getRed();
            this.gg = color.getGreen();
            this.bb = color.getBlue();
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 & 0xFF000000;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = (n3 & 0xFF0000) >> 16;
            int n7 = n3 & 0xFF;
            n5 = this.gg + n5 >> 1;
            n6 = this.rr + n6 >> 1;
            n7 = n7 + this.bb >> 1;
            return (n6 << 16) + (n5 << 8) + n7 + n4;
        }
    }
}

