/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.gr.java_conf.ccs2.comp.SwingUtil;
import jp.gr.java_conf.ccs2.core.CCSResource;

public class SelectionDialog
extends JDialog {
    protected List contents;
    protected int index = -1;
    private JLabel titleLabel;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JList list;

    public SelectionDialog(Frame frame, String string, List list) {
        super(frame, true);
        this.initComponents();
        this.contents = list;
        this.titleLabel.setText(string);
        this.updateList();
        this.okButton.setEnabled(false);
        this.pack();
        SwingUtil.setCenter(this);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SelectionDialog.this.closeDialog(windowEvent);
            }
        });
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(font.deriveFont((float)((double)font.getSize2D() * 1.5)));
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        borderLayout.setHgap(3);
        this.getContentPane().setLayout(borderLayout);
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.okButton.setText(CCSResource.getResourceString("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText(CCSResource.getResourceString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.list.setFixedCellWidth(200);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SelectionDialog.this.listKeyTyped(keyEvent);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SelectionDialog.this.listValueChanged(listSelectionEvent);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SelectionDialog.this.listMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void listKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.onOk();
        }
    }

    private void listValueChanged(ListSelectionEvent listSelectionEvent) {
        this.okButton.setEnabled(true);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.onOk();
    }

    private void listMouseClicked(MouseEvent mouseEvent) {
        this.okButton.setEnabled(true);
        if (mouseEvent.getClickCount() == 2) {
            this.onOk();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("first");
        linkedList.add("second");
        linkedList.add("third");
        SelectionDialog selectionDialog = new SelectionDialog((Frame)new JFrame(), "Dialog test", linkedList);
        selectionDialog.show();
        if (selectionDialog.getIndex() != -1) {
            System.out.println(linkedList.get(selectionDialog.getIndex()));
        } else {
            System.out.println("canceled");
        }
    }

    void updateList() {
        Object[] objectArray = this.contents.toArray();
        this.list.setListData(objectArray);
    }

    public void onOk() {
        int n = this.list.getSelectedIndex();
        if (n < 0 && n >= this.contents.size()) {
            JOptionPane.showMessageDialog(this, CCSResource.getResourceString("Please_select_an_item."));
            return;
        }
        this.index = n;
        this.dispose();
    }

    public int getIndex() {
        return this.index;
    }
}

