/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.ImageEditor;

public class Shader
extends Canvas
implements Runnable {
    public static final int PLAIN = 0;
    public static final int ITALIC = 1;
    public static final int BOLD = 2;
    public static final int defaultRight = 7;
    public static final int defaultDown = 6;
    public static final int defaultForColor = 0xCCCCCC;
    public static final int defaultBackColor = 0xFFFFFF;
    public static final int defaultTitleColor = 0x99BB99;
    public static final int defaultDepth = 10;
    public static final String defaultFontname = "Serif";
    public static final int defaultFontstyle = 0;
    public static final int defaultFontsize = 30;
    String title;
    int backColor;
    int forColor;
    int titleColor;
    int depth;
    int right;
    int down;
    int wright;
    int wdown;
    int width;
    int height;
    String fontname;
    int fontstyle;
    int fontsize;
    MessageListener parent = null;
    double frexx = 0.0;
    double frexy = 0.0;
    int frontdepth = 2;
    int xoffset;
    int yoffset;
    int lastWidth;
    int lastHeight;
    boolean fix = true;
    boolean selfResize = false;
    Image ibackOffice;
    Graphics gbackOffice;
    Image imgr;
    int isDraw;
    boolean paintRequest = false;
    Thread writer;
    static final int READY = 0;
    static final int PAINTING = 1;
    static final int FINISHED = 2;
    static final int FIRST = 3;
    int[] data = new int[320];

    public static void main(String[] stringArray) {
        String string = "Shader sample!!";
        int n = 0xCCCCCC;
        int n2 = 0xFFFFFF;
        int n3 = 0x99BB99;
        if (stringArray.length != 4) {
            System.out.println("stand alone usage sample:");
            System.out.println("% java jp.gr.java_conf.ccs2.comp.Shader [word] [0x000000:fg color] [0x000000:bg color] [0x000000:word color]");
        } else {
            string = stringArray[0];
            n = Integer.decode(stringArray[1]);
            n2 = Integer.decode(stringArray[2]);
            n3 = Integer.decode(stringArray[3]);
        }
        JFrame jFrame = new JFrame("Shader example");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Shader shader = new Shader(string, n, n2, n3, 15, 0, 0, defaultFontname, 40, 1);
        jFrame.getContentPane().add((Component)shader, "Center");
        jFrame.pack();
        jFrame.show();
    }

    public Shader() {
        this("Shader Component");
    }

    public Shader(String string) {
        this(string, 0xCCCCCC, 0xFFFFFF, 0x99BB99, defaultFontname, 30, 0);
    }

    public Shader(String string, int n, int n2, int n3, String string2, int n4, int n5) {
        this(string, n, n2, n3, 10, 7, 6, string2, n4, n5);
    }

    public Shader(String string, int n, int n2, int n3, int n4, int n5, int n6, String string2, int n7, int n8) {
        this(string, n, n2, n3, n4, n5, n6, string2, n7, n8, 0, 0, null);
        this.selfResize = true;
    }

    public Shader(String string, int n, int n2) {
        this(string, 0xCCCCCC, 0xFFFFFF, 0x99BB99, 10, 7, 6, defaultFontname, 0, 0, n, n2, null);
    }

    public Shader(String string, int n, int n2, int n3, int n4, int n5, int n6, String string2, int n7, int n8, int n9) {
        this(string, n, n2, n3, n4, n5, n6, string2, 0, n7, n8, n9, null);
    }

    public Shader(String string, int n, int n2, int n3, int n4, int n5, int n6, String string2, int n7, int n8, int n9, int n10, Image image) {
        int n11 = 0;
        while (n11 < 320) {
            this.data[n11] = (int)(Math.sin((double)(n11 % 256) * Math.PI / 128.0) * 1024.0);
            ++n11;
        }
        this.title = string;
        this.width = n9;
        this.height = n10;
        this.imgr = image;
        this.depth = n4;
        this.right = n5;
        this.down = n6;
        if (this.right < 0) {
            this.wright = -this.right;
            this.right = 0;
        } else {
            this.wright = 0;
        }
        if (this.down < 0) {
            this.wdown = -this.down;
            this.down = 0;
        } else {
            this.wdown = 0;
        }
        this.titleColor = n3;
        this.backColor = n2;
        this.forColor = n;
        this.depth = n4;
        this.fontname = string2;
        this.fontsize = n7;
        this.fontstyle = n8;
        if (n9 != 0) {
            this.setSize(n9, n10);
        } else {
            this.width = this.fontsize * string.length();
            this.height = this.fontsize * 2;
            this.setSize(this.width, this.height);
        }
        this.setDraw(3);
    }

    public void setSize(int n, int n2) {
        this.selfResize = false;
        super.setSize(n, n2);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.width, this.height);
        return dimension;
    }

    public void setSize(Dimension dimension) {
        this.selfResize = false;
        super.setSize(dimension);
    }

    public void setTitle(String string) {
        this.title = string;
        this.urgeRepaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setImage(Image image) {
        this.imgr = image;
        this.urgeRepaint();
    }

    public void paint(Graphics graphics) {
        this.branch(graphics);
        if (this.paintRequest) {
            this.paintRequest = false;
            Runnable runnable = new Runnable(){

                public void run() {
                    Shader.this.repaint();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void run() {
        this.lastWidth = this.width;
        this.lastHeight = this.height;
        this.ibackOffice = this.createImage(this.width, this.height);
        this.gbackOffice = this.ibackOffice.getGraphics();
        this.makeGraph(this.gbackOffice);
        this.setDraw(2);
        if (this.parent != null) {
            this.parent.message("", 0, new Dimension(this.width, this.height));
        }
        this.invalidate();
        Runnable runnable = new Runnable(){

            public void run() {
                Shader.this.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addNotify() {
        super.addNotify();
        if (this.selfResize) {
            FontMetrics fontMetrics = this.getFontMetrics(new Font(this.fontname, 0, (this.fontsize + this.depth) * 3));
            this.xoffset = (Math.abs(this.right) + Math.abs(this.wright)) * 2;
            this.yoffset = (Math.abs(this.down) + Math.abs(this.wdown)) * 2;
            this.setSize(fontMetrics.stringWidth(this.title) + this.xoffset, fontMetrics.getHeight() + this.yoffset);
        }
    }

    private synchronized void setDraw(int n) {
        this.isDraw = n;
    }

    private synchronized int getDraw() {
        return this.isDraw;
    }

    private void urgeRepaint() {
        if (this.getDraw() == 2) {
            this.setDraw(0);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Shader.this.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private synchronized void branch(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        switch (this.getDraw()) {
            default: {
                this.setDraw(1);
                this.threadStart();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.ibackOffice == null || this.width != this.lastWidth || this.height != this.lastHeight) {
                    this.setDraw(0);
                    this.paintRequest = true;
                    break;
                }
                graphics.drawImage(this.ibackOffice, 0, 0, this);
                this.writer = null;
            }
        }
    }

    private String[] splitString(String string) {
        string = string.replace('~', ' ');
        int n = string.length();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String(string.substring(n2, n2 + 1));
            ++n2;
        }
        return stringArray;
    }

    private Font[] makeFonts(String string, int n, int n2, int n3) {
        int n4 = 0;
        if ((n & 0) != 0) {
            n4 = 1;
        }
        if ((n & 1) != 0) {
            n4 += 2;
        }
        Font[] fontArray = new Font[n3];
        int n5 = 0;
        while (n5 < n3) {
            fontArray[n5] = new Font(string, n4, n2 + n5);
            ++n5;
        }
        return fontArray;
    }

    private Color[] makeColors(int n, int n2, int n3, int n4) {
        int n5 = (this.backColor >> 16) % 256;
        int n6 = (this.backColor >> 8) % 256;
        int n7 = this.backColor % 256;
        double d = (this.forColor >> 16) % 256;
        double d2 = (this.forColor >> 8) % 256;
        double d3 = this.forColor % 256;
        Color[] colorArray = new Color[n];
        int n8 = 0;
        while (n8 < n) {
            int n9 = n5 + (int)((d - (double)n5) * (double)n8 * (double)n8 / (double)n / (double)n) % 256;
            int n10 = n6 + (int)((d2 - (double)n6) * (double)n8 * (double)n8 / (double)n / (double)n) % 256;
            int n11 = n7 + (int)((d3 - (double)n7) * (double)n8 * (double)n8 / (double)n / (double)n) % 256;
            if (n11 > 255) {
                n11 = 255;
            }
            if (n10 > 255) {
                n10 = 255;
            }
            if (n9 > 255) {
                n9 = 255;
            }
            colorArray[this.depth - n8 - 1] = new Color(n9, n10, n11);
            ++n8;
        }
        return colorArray;
    }

    private void threadStart() {
        if (this.writer == null) {
            this.writer = new Thread(this);
            this.writer.start();
        }
    }

    private synchronized void makeGraph(Graphics graphics) {
        int n;
        FontMetrics fontMetrics;
        Font[] fontArray;
        int n2;
        int n3;
        Color[] colorArray;
        int n4;
        String[] stringArray;
        block15: {
            stringArray = this.splitString(this.title);
            n4 = this.title.length();
            colorArray = this.makeColors(this.depth, this.forColor, this.backColor, this.titleColor);
            this.xoffset = Math.abs(this.right) + Math.abs(this.wright);
            this.yoffset = Math.abs(this.down) + Math.abs(this.wdown);
            if (this.fontsize == 0 || this.fix) {
                this.fix = true;
                n3 = this.width / n4;
                n2 = this.height / 2;
                this.fontsize = n3 > n2 ? n2 : n3;
            }
            do {
                fontArray = new Font(this.fontname, this.fontstyle, this.fontsize + this.depth - 2);
                graphics.setFont((Font)fontArray);
                fontMetrics = graphics.getFontMetrics();
                n3 = 2 * this.xoffset;
                n = 0;
                while (n < n4) {
                    n3 += fontMetrics.stringWidth(stringArray[n]);
                    ++n;
                }
                n2 = fontMetrics.getHeight() + 2 * this.yoffset;
                if (n3 < this.width && n2 < this.height) {
                    this.xoffset = this.width / 2 - n3 / 2;
                    break block15;
                }
                double d = n3 < this.width ? (double)this.width / (double)n3 : (double)this.height / (double)n2;
                if (d < 0.8) {
                    this.fontsize = (int)((double)this.fontsize * d);
                }
                this.fontsize -= 3;
            } while (this.fontsize >= 9);
            this.fontsize = 9;
        }
        fontArray = this.makeFonts(this.fontname, this.fontstyle, this.fontsize, this.depth);
        graphics.setColor(colorArray[this.depth - 1]);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setFont(fontArray[this.depth - 1]);
        fontMetrics = graphics.getFontMetrics();
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = fontMetrics.stringWidth(stringArray[n5]);
            ++n5;
        }
        this.yoffset += this.height / 2 + (fontMetrics.getAscent() - fontMetrics.getDescent()) / 4;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.depth - 1;
        while (n10 > 0) {
            int n11 = n10 - 1;
            graphics.setColor(colorArray[n10]);
            graphics.setFont(fontArray[n10]);
            n2 = n10 * this.frontdepth;
            if (n10 == this.depth - 1) {
                n11 += 2;
            }
            if (n10 == this.depth - 2) {
                ++n11;
            }
            int n12 = 0;
            while (n12 < n2) {
                int n13 = 256 * n12 / n2;
                int n14 = n10 + 4 + n11 * this.cos(n13) >> 10;
                n = n10 + n11 * this.sin(n13) >> 10;
                n3 = 0;
                n8 = this.xoffset + this.right + n14;
                n9 = this.yoffset + this.down + n;
                int n15 = 0;
                while (n15 < n4) {
                    graphics.drawString(stringArray[n15], n8 + n3, n9);
                    n3 += nArray[n15] - 2;
                    ++n15;
                }
                if (n6 < (n8 += n3)) {
                    n6 = n8;
                }
                if (n7 < n9) {
                    n7 = n9;
                }
                ++n12;
            }
            --n10;
        }
        if (this.imgr != null) {
            ImageEditor imageEditor = new ImageEditor();
            graphics.drawImage(imageEditor.compoundImage(this.ibackOffice, this.imgr, this.forColor, this.backColor), 0, 0, this);
        }
        graphics.setColor(new Color(this.titleColor));
        n3 = 0;
        int n16 = 0;
        while (n16 < n4) {
            graphics.drawString(stringArray[n16], this.xoffset + n3 + this.wright + (int)(this.frexx * (double)this.depth), this.yoffset + this.wdown + (int)(this.frexy * (double)this.depth));
            n3 += nArray[n16] - 2;
            ++n16;
        }
    }

    int sin(int n) {
        return this.data[n &= 0xFF];
    }

    int cos(int n) {
        n = (n & 0xFF) + 64;
        return this.data[n];
    }
}

