/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jp.gr.java_conf.ccs2.util.BTree;
import jp.gr.java_conf.ccs2.util.Comparable;
import jp.gr.java_conf.ccs2.util.ComparableClass;
import jp.gr.java_conf.ccs2.util.TreeStructure;

public class TreeStructureSwingViewer {
    JFrame frame;
    JTree tree;

    public TreeStructureSwingViewer(TreeStructure treeStructure) {
        this.setTree(treeStructure);
    }

    public void setTree(TreeStructure treeStructure) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.translate(treeStructure);
        this.show(defaultMutableTreeNode);
    }

    protected DefaultMutableTreeNode translate(TreeStructure treeStructure) {
        String string = treeStructure.getTreeNodeExpression();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        TreeStructure[] treeStructureArray = treeStructure.getTreeNodes();
        if (treeStructureArray != null && treeStructureArray.length > 0) {
            int n = 0;
            while (n < treeStructureArray.length) {
                defaultMutableTreeNode.add(this.translate(treeStructureArray[n]));
                ++n;
            }
        }
        return defaultMutableTreeNode;
    }

    protected void show(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.frame == null) {
            this.frame = new JFrame("Tree Viewer");
            ((Component)this.frame).setSize(500, 600);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        if (this.tree == null) {
            this.tree = new JTree(defaultMutableTreeNode);
            this.frame.getContentPane().add(new JScrollPane(this.tree));
        } else {
            this.tree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        }
        this.frame.show();
    }

    public static void main(String[] stringArray) {
        BTree bTree = new BTree();
        bTree.addElement(TreeStructureSwingViewer.n(2.0));
        bTree.addElement(TreeStructureSwingViewer.n(3.0));
        bTree.addElement(TreeStructureSwingViewer.n(1.0));
        bTree.addElement(TreeStructureSwingViewer.n(5.0));
        bTree.addElement(TreeStructureSwingViewer.n(4.0));
        bTree.addElement(TreeStructureSwingViewer.n(6.0));
        TreeStructureSwingViewer treeStructureSwingViewer = new TreeStructureSwingViewer(bTree);
    }

    static Comparable n(double d) {
        double d2 = d;
        return new ComparableClass(d2){
            double num;
            private final /* synthetic */ double val$aa;
            {
                this.num = this.val$aa = d;
            }

            public double getValue() {
                return this.num;
            }

            public String toString() {
                return "" + this.getValue();
            }
        };
    }
}

