/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import jp.gr.java_conf.ccs2.comp.BufferedCanvas;
import jp.gr.java_conf.ccs2.comp.OriginalFont;
import jp.gr.java_conf.ccs2.comp.RichString;
import jp.gr.java_conf.ccs2.util.BTree;
import jp.gr.java_conf.ccs2.util.Comparable;
import jp.gr.java_conf.ccs2.util.ComparableClass;
import jp.gr.java_conf.ccs2.util.TreeStructure;

public class TreeStructureViewer {
    JFrame frame;
    TreeViewer tree;

    public TreeStructureViewer(TreeStructure treeStructure) {
        this.setTree(treeStructure);
    }

    public void setTree(TreeStructure treeStructure) {
        this.show(treeStructure);
    }

    protected void show(TreeStructure treeStructure) {
        if (this.frame == null) {
            this.frame = new JFrame("Tree Viewer");
            ((Component)this.frame).setSize(600, 500);
        }
        if (this.tree == null) {
            this.tree = new TreeViewer(treeStructure);
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            this.frame.getContentPane().add(jScrollPane);
        } else {
            this.tree.setModel(treeStructure);
        }
        this.frame.show();
    }

    public static void main(String[] stringArray) {
        BTree bTree = new BTree();
        bTree.addElement(TreeStructureViewer.n(2.0));
        bTree.addElement(TreeStructureViewer.n(3.0));
        bTree.addElement(TreeStructureViewer.n(1.0));
        bTree.addElement(TreeStructureViewer.n(5.0));
        bTree.addElement(TreeStructureViewer.n(4.0));
        bTree.addElement(TreeStructureViewer.n(6.0));
        TreeStructureViewer treeStructureViewer = new TreeStructureViewer(bTree);
    }

    static Comparable n(double d) {
        double d2 = d;
        return new ComparableClass(d2){
            double num;
            private final /* synthetic */ double val$aa;
            {
                this.num = this.val$aa = d;
            }

            public double getValue() {
                return this.num;
            }

            public String toString() {
                return "" + this.getValue();
            }
        };
    }

    class TreeViewer
    extends BufferedCanvas {
        int vSpace = 15;
        int hSpace = 15;
        OriginalFont fontInfo = new OriginalFont(Color.black, Color.lightGray, new Font("Serif", 0, 16));
        TreeStructure root;
        Vector paintList = new Vector();

        TreeViewer(TreeStructure treeStructure) {
            this.setModel(treeStructure);
            this.setHeavyContents(true);
        }

        public void setModel(TreeStructure treeStructure) {
            this.root = treeStructure;
        }

        public void bpaint(Graphics graphics) {
            PaintNode paintNode = this.adjustSize(graphics);
            this.painter(graphics, paintNode, new Point(this.hSpace, this.vSpace), null);
        }

        PaintNode adjustSize(Graphics graphics) {
            boolean bl = false;
            boolean bl2 = false;
            this.paintList.removeAllElements();
            PaintNode paintNode = this.calcSize(graphics, this.root);
            int n = paintNode.w + this.hSpace * 2;
            int n2 = paintNode.h + this.vSpace * 2;
            this.setSize(n, n2);
            return paintNode;
        }

        PaintNode calcSize(Graphics graphics, TreeStructure treeStructure) {
            RichString richString = new RichString(treeStructure.getTreeNodeExpression(), this.fontInfo);
            Dimension dimension = richString.getSize(graphics);
            TreeStructure[] treeStructureArray = treeStructure.getTreeNodes();
            Dimension dimension2 = new Dimension(0, 0);
            PaintNode[] paintNodeArray = null;
            if (treeStructureArray != null && treeStructureArray.length > 0) {
                paintNodeArray = new PaintNode[treeStructureArray.length];
                int n = 0;
                while (n < treeStructureArray.length) {
                    PaintNode paintNode;
                    paintNodeArray[n] = paintNode = this.calcSize(graphics, treeStructureArray[n]);
                    dimension2.width += paintNode.w + this.hSpace;
                    if (dimension2.height < paintNode.h) {
                        dimension2.height = paintNode.h;
                    }
                    ++n;
                }
                dimension2.height += dimension.height + this.vSpace;
            } else {
                dimension2 = new Dimension(dimension.width, dimension.height);
            }
            return new PaintNode(richString, dimension2.width, dimension2.height, paintNodeArray);
        }

        void painter(Graphics graphics, PaintNode paintNode, Point point, Point point2) {
            int n;
            int n2;
            Dimension dimension = paintNode.name.getSize(graphics);
            int n3 = point.x + paintNode.w / 2 - dimension.width / 2;
            int n4 = point.y;
            if (paintNode.children != null) {
                int n5 = 0;
                n2 = 0;
                n = 0;
                while (n < paintNode.children.length) {
                    n5 += point.x + n2 + paintNode.children[n].w / 2;
                    n2 += paintNode.children[n].w + this.hSpace;
                    ++n;
                }
                n3 = n5 / paintNode.children.length - dimension.width / 2;
            }
            if (point2 != null) {
                graphics.drawLine(n3 + dimension.width / 2, n4, point2.x, point2.y);
            }
            paintNode.name.drawContents(graphics, n3, n4);
            Point point3 = new Point(n3 + dimension.width / 2, n4 + dimension.height);
            if (paintNode.children != null) {
                n2 = 0;
                n = 0;
                while (n < paintNode.children.length) {
                    int n6 = point.x + n2;
                    int n7 = point.y + dimension.height + this.vSpace;
                    this.painter(graphics, paintNode.children[n], new Point(n6, n7), point3);
                    n2 += paintNode.children[n].w + this.hSpace;
                    ++n;
                }
            }
        }

        class PaintNode {
            RichString name;
            int x;
            int y;
            int w;
            int h;
            PaintNode[] children;

            PaintNode(RichString richString, int n, int n2, PaintNode[] paintNodeArray) {
                this.name = richString;
                this.w = n;
                this.h = n2;
                this.children = paintNodeArray;
            }
        }
    }
}

