/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.core.AppContext;
import jp.gr.java_conf.ccs2.util.ResourceFile;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class AppConfig {
    protected static String separator = ":";
    protected AppContext appContext;
    HashMap table = new HashMap();
    List fileList = new LinkedList();

    public AppConfig(String string, String string2, String[] stringArray) {
        this.setupDefaults(string);
        this.setupFile(string2);
        this.setupArgs(stringArray);
    }

    public AppConfig(String string, String[] stringArray) {
        this(null, string, stringArray);
    }

    public AppConfig(String[] stringArray) {
        this(null, stringArray);
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    protected void setupDefaults(String string) {
        try {
            this.setupProp(ResourceBundle.getBundle(string));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected void setupFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        this.setupProp(ResourceFile.getResourceFile(string));
    }

    protected void setupProp(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return;
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            try {
                String string2 = resourceBundle.getString(string);
                if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes")) {
                    this.table.put(string, Boolean.TRUE);
                    continue;
                }
                if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no")) {
                    this.table.put(string, Boolean.FALSE);
                    continue;
                }
                this.table.put(string, string2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    protected void setupArgs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '-') {
                this.fileList.add(stringArray[n]);
            } else {
                int n2 = stringArray[n].indexOf(separator);
                if (n2 == -1) {
                    this.table.put(stringArray[n].substring(1), Boolean.TRUE);
                } else {
                    this.table.put(stringArray[n].substring(1, n2), stringArray[n].substring(n2 + 1));
                }
            }
            ++n;
        }
    }

    public String getDumpProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.table.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.table.get(string).toString();
            stringBuffer.append(string + ":" + string2 + "\n");
        }
        int n = 0;
        while (n < this.fileList.size()) {
            stringBuffer.append("FILE:" + this.fileList.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean getOption(String string) {
        Object v = this.table.get(string);
        if (v == null || !(v instanceof Boolean)) {
            return false;
        }
        return (Boolean)v == Boolean.TRUE;
    }

    public String getOptionString(String string) {
        Object v = this.table.get(string);
        if (v == null || !(v instanceof String)) {
            return null;
        }
        return (String)v;
    }

    public int getOptionInteger(String string) {
        String string2 = this.getOptionString(string);
        if (StringUtil.isNull(string2)) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.appContext != null) {
                this.appContext.getMonitor().warning("property [" + string + "] is wrong number.");
            }
            return -1;
        }
    }

    public double getOptionDouble(String string) {
        String string2 = this.getOptionString(string);
        if (StringUtil.isNull(string2)) {
            return -1.0;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.appContext != null) {
                this.appContext.getMonitor().warning("property [" + string + "] is wrong number.");
            }
            return -1.0;
        }
    }

    public String getArgumentFile() {
        if (this.fileList.size() == 0) {
            return null;
        }
        return (String)this.fileList.get(0);
    }

    public String[] getArgumentFiles() {
        String[] stringArray = new String[this.fileList.size()];
        return this.fileList.toArray(stringArray);
    }
}

