/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.AppContext;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public abstract class AppContextClass
implements AppContext {
    protected MessageMonitor monitor;
    protected AppConfig config;
    protected String resourceUri;
    ResourceBundle resources;
    boolean loadFailed = false;

    protected AppContextClass(String[] stringArray) {
        this(stringArray, null);
    }

    protected AppContextClass(String[] stringArray, String string) {
        this.resourceUri = string;
        this.config = new AppConfig(stringArray);
        this.setupMonitor();
    }

    protected AppContextClass(AppConfig appConfig, String string) {
        this.resourceUri = string;
        this.config = appConfig;
        this.setupMonitor();
    }

    protected void setupMonitor() {
        this.monitor = new MessageMonitor(this.config);
    }

    public AppConfig getConfig() {
        return this.config;
    }

    public MessageMonitor getMonitor() {
        return this.monitor;
    }

    protected void loadResources() {
        Locale locale = Locale.getDefault();
        try {
            this.resources = ResourceBundle.getBundle(this.resourceUri, locale);
        }
        catch (MissingResourceException missingResourceException) {
            this.getMonitor().error("property file [" + this.resourceUri + "] not found");
            this.loadFailed = true;
        }
    }

    public String getResourceString(String string) {
        if (this.resources == null && !this.loadFailed) {
            this.loadResources();
        }
        try {
            return this.resources.getString(string);
        }
        catch (RuntimeException runtimeException) {
            this.getMonitor().warning("no string :" + string);
            return string;
        }
    }

    public String getResourceStringNoWarning(String string) {
        if (this.resources == null && !this.loadFailed) {
            this.loadResources();
        }
        try {
            return this.resources.getString(string);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public String getResourceString(String string, String string2) {
        return MessageFormat.format(this.getResourceString(string), string2);
    }
}

