/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import jp.gr.java_conf.ccs2.io.ConsoleReader;

public class ClassFileLoader
extends ClassLoader {
    protected Hashtable classes = new Hashtable();
    protected String path;

    public ClassFileLoader() {
        this.path = "";
    }

    public ClassFileLoader(String string) {
        if (string.length() != 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        this.path = string;
    }

    public Class load(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClass(string, bl);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string);
        if (clazz == null) {
            try {
                return this.findSystemClass(string);
            }
            catch (Exception exception) {
                clazz = this.buildClass(string);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private Class buildClass(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.path + string + ".class"));
            return this.loadClass(bufferedInputStream);
        }
        catch (Exception exception) {
            System.out.println("class file not found : " + string);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class loadClass(InputStream inputStream) throws IOException {
        try {
            Object object;
            try {
                void var2_3;
                int n;
                byte[] byArray = new byte[4096];
                int n2 = 0;
                while ((n = inputStream.read((byte[])var2_3, n2, ((void)var2_3).length - n2)) >= 0) {
                    if ((n2 += n) != ((void)var2_3).length) continue;
                    object = new byte[n2 * 2];
                    System.arraycopy(var2_3, 0, object, 0, n2);
                    Object object2 = object;
                }
                object = this.defineClass(null, (byte[])var2_3, 0, n2);
                Object var7_9 = null;
                if (inputStream == null) return object;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("class not loaded");
        }
    }

    public static void main(String[] stringArray) {
        ConsoleReader consoleReader = new ConsoleReader();
        String string = "";
        if (stringArray.length == 0) {
            System.out.println("input class name");
            string = consoleReader.read();
        } else {
            string = stringArray[0];
        }
        try {
            ClassFileLoader classFileLoader = new ClassFileLoader("");
            Class clazz = classFileLoader.load(string, true);
            System.out.println("class [" + clazz.getName() + "] loaded.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

