/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.Serializable;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractHedgeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;

public abstract class AbstractElementModel
extends AbstractHedgeModel
implements Serializable {
    static final long serialVersionUID = -3655376765587144325L;
    int occurs = 0;
    public static final int OCCURS_ONE = 0;
    public static final int OCCURS_MORE_THAN_ZERO = 1;
    public static final int OCCURS_MORE_THAN_ONE = 2;
    public static final int OCCURS_ZERO_OR_ONE = 3;
    public static final String[] occurSymbols = new String[]{"", "*", "+", "?"};

    protected AbstractElementModel(ModuleModel moduleModel) {
        super(moduleModel);
    }

    public static int getOccursBySymbol(String string) {
        string = string.trim();
        int n = 0;
        while (n < occurSymbols.length) {
            if (occurSymbols[n].equals(string)) {
                return n;
            }
            ++n;
        }
        throw new RuntimeException("No such occurs symbol! [" + string + "]");
    }

    public static String getOccurSymbol(int n) {
        if (n < 0 || n >= occurSymbols.length) {
            throw new RuntimeException("Invalid occur id!");
        }
        return occurSymbols[n];
    }

    public void setOccurs(int n) {
        this.occurs = n;
    }

    public void setOccurs(String string) {
        this.setOccurs(AbstractElementModel.getOccursBySymbol(string));
    }

    public int getOccurs() {
        return this.occurs;
    }

    public String getOccurSymbol() {
        return AbstractElementModel.getOccurSymbol(this.getOccurs());
    }

    protected void copyTo(AbstractElementModel abstractElementModel) {
        abstractElementModel.setOccurs(this.getOccurs());
    }
}

