/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.util.ArrayList;
import java.util.List;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractHedgeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;

public abstract class AbstractMultiElementModel
extends AbstractElementModel {
    static final long serialVersionUID = 5482962339092314034L;
    List elements = new ArrayList();

    protected AbstractMultiElementModel(ModuleModel moduleModel) {
        super(moduleModel);
    }

    public void addElement(AbstractHedgeModel abstractHedgeModel) {
        if (abstractHedgeModel == null) {
            return;
        }
        this.elements.add(abstractHedgeModel);
    }

    public void removeElement(AbstractHedgeModel abstractHedgeModel) {
        if (abstractHedgeModel == null) {
            return;
        }
        this.elements.remove(abstractHedgeModel);
    }

    public AbstractHedgeModel[] getElements() {
        AbstractHedgeModel[] abstractHedgeModelArray = new AbstractHedgeModel[this.elements.size()];
        return this.elements.toArray(abstractHedgeModelArray);
    }

    public AbstractHedgeModel getElement(int n) {
        return (AbstractHedgeModel)this.elements.get(n);
    }

    public int getElementNum() {
        return this.elements.size();
    }

    public boolean canMoveElementUpward(ElementOperation elementOperation) {
        int n = this.elements.indexOf(elementOperation);
        if (n < 0) {
            if (elementOperation instanceof ObjectModel) {
                return this.canMoveElementUpward(this.getCorrespondRef((ObjectModel)elementOperation));
            }
            return false;
        }
        return n > 0;
    }

    public void moveElementUpward(ElementOperation elementOperation) {
        if (!this.canMoveElementUpward(elementOperation)) {
            throw new InternalError("Forbidden operation.");
        }
        ElementOperation elementOperation2 = elementOperation;
        int n = this.elements.indexOf(elementOperation);
        if (n == -1) {
            if (elementOperation instanceof ObjectModel) {
                elementOperation2 = this.getCorrespondRef((ObjectModel)elementOperation);
                n = this.elements.indexOf(elementOperation2);
            }
            if (n == -1) {
                throw new InternalError("Unexpected error.");
            }
        }
        this.elements.remove(elementOperation2);
        this.elements.add(n - 1, elementOperation2);
    }

    public boolean canMoveElementDownward(ElementOperation elementOperation) {
        int n = this.elements.indexOf(elementOperation);
        if (n < 0) {
            if (elementOperation instanceof ObjectModel) {
                return this.canMoveElementDownward(this.getCorrespondRef((ObjectModel)elementOperation));
            }
            return false;
        }
        return n < this.elements.size() - 1;
    }

    public void moveElementDownward(ElementOperation elementOperation) {
        if (!this.canMoveElementDownward(elementOperation)) {
            throw new InternalError("Forbidden operation.");
        }
        ElementOperation elementOperation2 = elementOperation;
        int n = this.elements.indexOf(elementOperation);
        if (n == -1) {
            if (elementOperation instanceof ObjectModel) {
                elementOperation2 = this.getCorrespondRef((ObjectModel)elementOperation);
                n = this.elements.indexOf(elementOperation2);
            }
            if (n == -1) {
                throw new InternalError("Unexpected error.");
            }
        }
        this.elements.remove(elementOperation2);
        this.elements.add(n + 1, elementOperation2);
    }

    public boolean canAddElement() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addOpElements(ElementOperation[] elementOperationArray) {
        if (elementOperationArray == null || elementOperationArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < elementOperationArray.length) {
            if (elementOperationArray[n] instanceof AbstractHedgeModel) {
                if (elementOperationArray[n].getOpElementLevel() != 1) throw new InternalError("Object is now the subclass of AbstractHedgeModel.(bug)");
                this.addElement((AbstractHedgeModel)elementOperationArray[n]);
            } else {
                if (!(elementOperationArray[n] instanceof ObjectModel)) throw new InternalError("Forbidden operation.(bug)");
                this.addElement(ElementUtil.getRef(this.getParentModule(), (ObjectModel)elementOperationArray[n]));
            }
            ++n;
        }
    }

    public ElementOperation[] getOpElements() {
        if (this.elements.size() == 0) {
            return null;
        }
        ElementOperation[] elementOperationArray = new ElementOperation[this.elements.size()];
        return this.elements.toArray(elementOperationArray);
    }

    public void removeOpElement(ElementOperation elementOperation) {
        RefElementModel refElementModel;
        if (elementOperation instanceof AbstractHedgeModel && this.elements.contains(elementOperation)) {
            this.removeElement((AbstractHedgeModel)elementOperation);
            return;
        }
        if (elementOperation instanceof ObjectModel && (refElementModel = this.getCorrespondRef((ObjectModel)elementOperation)) != null) {
            this.removeElement(refElementModel);
            return;
        }
        throw new InternalError("No such element.(bug) : " + elementOperation.getClass().getName() + " : " + this.elements);
    }

    private RefElementModel getCorrespondRef(ObjectModel objectModel) {
        ElementOperation[] elementOperationArray = this.getOpElements();
        if (elementOperationArray == null) {
            return null;
        }
        int n = 0;
        while (n < elementOperationArray.length) {
            RefElementModel refElementModel;
            if (elementOperationArray[n] instanceof RefElementModel && (refElementModel = (RefElementModel)elementOperationArray[n]).getAt() == objectModel) {
                return refElementModel;
            }
            ++n;
        }
        return null;
    }

    public boolean acceptOpElement(ElementOperation elementOperation) {
        return elementOperation.getOpElementLevel() == 1 || elementOperation.getOpElementLevel() == 2;
    }

    protected ElementOperation getOpChildrenCopy(AbstractMultiElementModel abstractMultiElementModel) {
        ElementOperation[] elementOperationArray = this.getOpElements();
        if (elementOperationArray == null) {
            return abstractMultiElementModel;
        }
        ElementOperation[] elementOperationArray2 = new ElementOperation[elementOperationArray.length];
        int n = 0;
        while (n < elementOperationArray2.length) {
            elementOperationArray2[n] = elementOperationArray[n].getOpCopy();
            ++n;
        }
        abstractMultiElementModel.addOpElements(elementOperationArray2);
        this.copyTo(abstractMultiElementModel);
        return abstractMultiElementModel;
    }
}

