/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.Serializable;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractHedgeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;

public class HedgeRuleElementModel
implements Serializable,
ElementOperation {
    static final long serialVersionUID = 46000408259074347L;
    String label;
    String comment;
    AbstractHedgeModel model;
    ModuleModel parentModule;

    public HedgeRuleElementModel(ModuleModel moduleModel, String string) {
        this.parentModule = moduleModel;
        this.label = string;
    }

    public ModuleModel getParentModule() {
        return this.parentModule;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setElement(AbstractHedgeModel abstractHedgeModel) {
        this.model = abstractHedgeModel;
    }

    public AbstractHedgeModel getElement() {
        return this.model;
    }

    public boolean canAddElement() {
        return this.model == null;
    }

    public void addOpElements(ElementOperation[] elementOperationArray) {
        if (elementOperationArray == null || elementOperationArray.length == 0) {
            return;
        }
        if (this.acceptOpElement(elementOperationArray[0])) {
            if (elementOperationArray[0] instanceof AbstractHedgeModel) {
                this.setElement((AbstractHedgeModel)elementOperationArray[0]);
            } else if (elementOperationArray[0] instanceof ObjectModel) {
                this.setElement(ElementUtil.getRef(this.getParentModule(), (ObjectModel)elementOperationArray[0]));
            } else {
                throw new InternalError("Object is now the subclass of ElementModel.(bug)");
            }
        }
    }

    public ElementOperation[] getOpElements() {
        if (this.getElement() == null) {
            return null;
        }
        ElementOperation[] elementOperationArray = new ElementOperation[]{this.getElement()};
        return elementOperationArray;
    }

    public void removeOpElement(ElementOperation elementOperation) {
        RefElementModel refElementModel;
        if (elementOperation == this.getElement()) {
            this.setElement(null);
            return;
        }
        if (this.getElement() instanceof RefElementModel && (refElementModel = (RefElementModel)this.getElement()).getAt() == elementOperation) {
            this.setElement(null);
            return;
        }
        throw new InternalError("Invalid argument.");
    }

    public boolean acceptOpElement(ElementOperation elementOperation) {
        return elementOperation.getOpElementLevel() == 1 || elementOperation.getOpElementLevel() == 2;
    }

    public int getOpElementLevel() {
        return -1;
    }

    public ElementOperation getOpCopy() {
        HedgeRuleElementModel hedgeRuleElementModel = ElementUtil.getHedgeRule(this.getParentModule(), this.getLabel());
        if (this.getOpElements() != null) {
            hedgeRuleElementModel.addOpElements(ElementUtil.toArray(this.getOpElements()[0].getOpCopy()));
        }
        return hedgeRuleElementModel;
    }
}

