/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributePoolModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeRefModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.VisitorClass;

class IncludeElementCheckVisitor
extends VisitorClass {
    List usedObjects = new ArrayList();
    ModuleModel curModule;
    ModuleModel mainModule;
    List curObjects = new ArrayList();

    IncludeElementCheckVisitor(ModuleModel moduleModel, ModuleModel moduleModel2) {
        this.curModule = moduleModel;
        this.mainModule = moduleModel2;
        this.curObjects.addAll(Arrays.asList(moduleModel.getAllObjects()));
        this.curObjects.addAll(Arrays.asList(moduleModel.getAllHedgeRules()));
        this.curObjects.addAll(Arrays.asList(moduleModel.getAllAttributePools()));
    }

    public int getAllowedNestedLoop() {
        return 0;
    }

    public boolean isOnlyFirstContact() {
        return true;
    }

    private String getRes(String string, String string2) {
        Object[] objectArray = new String[]{string2};
        String string3 = MainApp.getResString(string);
        return MessageFormat.format(string3, objectArray);
    }

    public void objectEnter(ObjectModel objectModel) {
        this.checkAttributes(objectModel.getAttributes());
    }

    private void checkAttributes(AttributeModel[] attributeModelArray) {
        int n = 0;
        while (n < attributeModelArray.length) {
            AttributeRefModel attributeRefModel;
            if (attributeModelArray[n] instanceof AttributeRefModel && this.curObjects.contains((attributeRefModel = (AttributeRefModel)attributeModelArray[n]).getAt())) {
                this.usedObjects.add(this.getRes("AttributePool{0}", attributeRefModel.getAt().getRole()));
            }
            ++n;
        }
    }

    public void end(ModuleModel moduleModel) {
        AttributePoolModel[] attributePoolModelArray = this.mainModule.getAttributePools();
        int n = 0;
        while (n < attributePoolModelArray.length) {
            this.checkAttributes(attributePoolModelArray[n].getAttributes());
            ++n;
        }
    }

    public void hedgeRef(HedgeRefElementModel hedgeRefElementModel) {
        if (this.curObjects.contains(hedgeRefElementModel.getAt())) {
            this.usedObjects.add(this.getRes("HedgeRule{0}", hedgeRefElementModel.getAt().getLabel()));
        }
    }

    public void ref(RefElementModel refElementModel) {
        if (this.curObjects.contains(refElementModel.getAt())) {
            this.usedObjects.add(this.getRes("ElementRule{0}", refElementModel.getAt().getLabel()));
        }
    }
}

