/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.comp.SwingUtil;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.AppContext;
import jp.gr.java_conf.ccs2.core.AppContextClass;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.MainFrame;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.ModulePanel;
import jp.gr.java_conf.ccs2.util.ExtensionFileFilter;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class MainApp
extends AppContextClass {
    static MainApp app;
    ResourceBundle iconResources;
    boolean iconLoadFailed = false;

    public static void main(String[] stringArray) {
        app = new MainApp(stringArray);
        app.printVersionString();
        app.getMonitor().debug(app.getMonitor().getState());
        app.getMonitor().debug(app.getConfig().getDumpProperties());
        app.setup();
    }

    protected MainApp(String[] stringArray) {
        super(new AppConfig("jp.gr.java_conf.ccs2.tool.mkrelax.MkRelax", "MkRelax.properties", stringArray), "jp.gr.java_conf.ccs2.tool.mkrelax.message");
    }

    void printVersionString() {
        Object[] objectArray = new String[]{this.getResourceString("copyright"), this.getResourceString("programName"), this.getResourceString("version")};
        String string = "{0}\n{1} version {2}";
        System.out.println(MessageFormat.format(string, objectArray));
    }

    void printUsage() {
        String string = "Usage: java -jar mkrelax.jar [RELAX file]";
        System.out.println(string);
    }

    void setup() {
        ModuleModel moduleModel = null;
        if (StringUtil.isNull(this.getConfig().getArgumentFile())) {
            moduleModel = ModuleModel.createNewModule();
        } else {
            try {
                moduleModel = ModuleModel.loadModuleFromRelax(this.getConfig().getArgumentFile());
            }
            catch (IOException iOException) {
                this.getMonitor().recordStackTrace(iOException);
            }
        }
        this.openFrame(moduleModel);
    }

    void openFrame(ModuleModel moduleModel) {
        this.magnify();
        MainFrame mainFrame = new MainFrame(new ModulePanel(moduleModel));
        mainFrame.pack();
        mainFrame.show();
    }

    void magnify() {
        if (this.getConfig().getOptionDouble("mag") > 0.0) {
            SwingUtil.magnifyAllFont((float)this.getConfig().getOptionDouble("mag"));
        }
    }

    protected void iconLoadResources() {
        try {
            this.iconResources = ResourceBundle.getBundle("jp.gr.java_conf.ccs2.tool.mkrelax.iconResource");
        }
        catch (MissingResourceException missingResourceException) {
            this.getMonitor().error("[iconResource.properties] not found");
            this.iconLoadFailed = true;
        }
    }

    public String getResourceString(String string) {
        if (this.iconResources == null && !this.iconLoadFailed) {
            this.iconLoadResources();
        }
        String string2 = null;
        try {
            string2 = this.iconResources.getString(string);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = super.getResourceString(string);
        }
        this.getMonitor().debug("RES:" + string + " : " + string2);
        if (string2 != null) {
            return string2;
        }
        this.getMonitor().warning("No properties : " + string);
        return string;
    }

    public static AppContext getAppContext() {
        if (app == null) {
            MainApp.temporaryContext();
        }
        return app;
    }

    public static String getResString(String string) {
        return MainApp.getAppContext().getResourceString(string);
    }

    public static String getResString(String string, String string2) {
        return ((MainApp)MainApp.getAppContext()).getResourceString(string, string2);
    }

    protected static void temporaryContext() {
        app = new MainApp(new String[0]);
    }

    public static ExtensionFileFilter getRelaxFileFilter() {
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(".rlx");
        extensionFileFilter.setDescription(MainApp.getResString("RelaxModuleFile"));
        extensionFileFilter.addExtension(".rxm");
        return extensionFileFilter;
    }
}

