/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.Serializable;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractHedgeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;

public class MixedModel
extends ElementModel
implements Serializable {
    static final long serialVersionUID = 4822652831778886921L;
    AbstractHedgeModel element;

    public MixedModel(ModuleModel moduleModel) {
        super(moduleModel);
    }

    public MixedModel(ModuleModel moduleModel, AbstractHedgeModel abstractHedgeModel) {
        this(moduleModel);
        this.setElement(abstractHedgeModel);
    }

    public void setElement(AbstractHedgeModel abstractHedgeModel) {
        this.element = abstractHedgeModel;
    }

    public AbstractHedgeModel getElement() {
        return this.element;
    }

    public boolean canAddElement() {
        return this.getElement() == null;
    }

    public void addOpElements(ElementOperation[] elementOperationArray) {
        if (elementOperationArray == null || elementOperationArray.length == 0) {
            return;
        }
        if (this.acceptOpElement(elementOperationArray[0])) {
            if (elementOperationArray[0] instanceof AbstractHedgeModel) {
                this.setElement((AbstractHedgeModel)elementOperationArray[0]);
            } else if (elementOperationArray[0] instanceof ObjectModel) {
                this.setElement(ElementUtil.getRef(this.getParentModule(), (ObjectModel)elementOperationArray[0]));
            } else {
                throw new InternalError("Object is now the subclass of AbstractHedgeModel.(bug)");
            }
        }
    }

    public ElementOperation[] getOpElements() {
        if (this.getElement() == null) {
            return null;
        }
        ElementOperation[] elementOperationArray = new ElementOperation[]{this.getElement()};
        return elementOperationArray;
    }

    public void removeOpElement(ElementOperation elementOperation) {
        RefElementModel refElementModel;
        if (elementOperation == this.getElement()) {
            this.setElement(null);
            return;
        }
        if (this.getElement() instanceof RefElementModel && (refElementModel = (RefElementModel)this.getElement()).getAt() == elementOperation) {
            this.setElement(null);
            return;
        }
        throw new InternalError("Invalid argument.");
    }

    public ElementOperation getOpCopy() {
        MixedModel mixedModel = ElementUtil.getMixed(this.getParentModule());
        if (this.getOpElements() != null) {
            mixedModel.addOpElements(ElementUtil.toArray(this.getOpElements()[0].getOpCopy()));
        }
        return mixedModel;
    }

    public int getOpElementLevel() {
        return 0;
    }

    public boolean acceptOpElement(ElementOperation elementOperation) {
        return elementOperation.getOpElementLevel() == 1 || elementOperation.getOpElementLevel() == 2;
    }
}

