/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributePoolModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementCollectVisitor;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRuleElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.MkRelaxException;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RelaxGenVisitor;
import jp.gr.java_conf.ccs2.tool.mkrelax.RelaxReader;
import jp.gr.java_conf.ccs2.tool.mkrelax.VisitorCenter;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class ModuleModel
implements ElementOperation,
Serializable {
    static final long serialVersionUID = 2505549755525109268L;
    private List attributePools = new ArrayList();
    private List hedgeRules = new ArrayList();
    private List objects = new ArrayList();
    private List includedModules = new ArrayList();
    private String moduleFilename;
    private String targetNameSpace;
    private String moduleComment;
    private String moduleVersion;
    private String relaxCoreVersion = "1.0";
    private transient boolean modifiedFlag = false;

    public ModuleModel(String string, String string2, String string3) {
        this.setModuleVersion(string3);
        this.setModuleComment(string);
        this.setTargetNameSpace(string2);
    }

    public ModuleModel getParentModule() {
        return this;
    }

    public void addRootObject(ObjectModel objectModel) {
        if (objectModel == null) {
            return;
        }
        this.objects.add(objectModel);
    }

    public void removeRootObject(ObjectModel objectModel) {
        if (objectModel == null) {
            return;
        }
        this.objects.remove(objectModel);
    }

    public ObjectModel[] getRootObjects() {
        ObjectModel[] objectModelArray = new ObjectModel[this.objects.size()];
        return this.objects.toArray(objectModelArray);
    }

    public ObjectModel getObjectByLabel(String string) {
        ObjectModel[] objectModelArray = this.getAllObjects();
        int n = 0;
        while (n < objectModelArray.length) {
            if (objectModelArray[n].getLabel().equals(string)) {
                return objectModelArray[n];
            }
            ++n;
        }
        return null;
    }

    public ObjectModel[] getObjects() {
        return this.getObjects(false);
    }

    public ObjectModel[] getExportableObjects() {
        return this.getObjects(true);
    }

    public ObjectModel[] getExportableAllObjects() {
        ElementCollectVisitor elementCollectVisitor = new ElementCollectVisitor(true);
        VisitorCenter.traverseAll(this, elementCollectVisitor);
        return elementCollectVisitor.getElements();
    }

    private ObjectModel[] getObjects(boolean bl) {
        ElementCollectVisitor elementCollectVisitor = new ElementCollectVisitor(bl);
        VisitorCenter.traverseAllInsideObjects(this, elementCollectVisitor);
        return elementCollectVisitor.getElements();
    }

    public ObjectModel[] getAllObjects() {
        ElementCollectVisitor elementCollectVisitor = new ElementCollectVisitor();
        VisitorCenter.traverseAllAroundModules(this, elementCollectVisitor);
        return elementCollectVisitor.getElements();
    }

    public AttributePoolModel getAttributePoolByRole(String string) {
        AttributePoolModel[] attributePoolModelArray = this.getAllAttributePools();
        int n = 0;
        while (n < attributePoolModelArray.length) {
            if (attributePoolModelArray[n].getRole().equals(string)) {
                return attributePoolModelArray[n];
            }
            ++n;
        }
        return null;
    }

    public void addAttributePool(AttributePoolModel attributePoolModel) {
        if (attributePoolModel == null) {
            return;
        }
        this.attributePools.add(attributePoolModel);
    }

    public void removeAttributePool(AttributePoolModel attributePoolModel) {
        if (attributePoolModel == null) {
            return;
        }
        this.attributePools.remove(attributePoolModel);
    }

    public AttributePoolModel[] getAttributePools() {
        return this.getAttributePools(null);
    }

    public AttributePoolModel[] getAttributePools(AttributePoolModel attributePoolModel) {
        ArrayList arrayList = new ArrayList(this.attributePools);
        if (attributePoolModel != null) {
            arrayList.remove(attributePoolModel);
        }
        AttributePoolModel[] attributePoolModelArray = new AttributePoolModel[arrayList.size()];
        return arrayList.toArray(attributePoolModelArray);
    }

    public AttributePoolModel[] getAllAttributePools() {
        return this.getAllAttributePools(null);
    }

    public AttributePoolModel[] getAllAttributePools(AttributePoolModel attributePoolModel) {
        ArrayList<AttributePoolModel> arrayList = new ArrayList<AttributePoolModel>(Arrays.asList(this.getAttributePools(attributePoolModel)));
        ModuleModel[] moduleModelArray = this.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            arrayList.addAll(Arrays.asList(moduleModelArray[n].getAttributePools(attributePoolModel)));
            ++n;
        }
        AttributePoolModel[] attributePoolModelArray = new AttributePoolModel[arrayList.size()];
        return arrayList.toArray(attributePoolModelArray);
    }

    public HedgeRuleElementModel getHedgeRuleByLabel(String string) {
        HedgeRuleElementModel[] hedgeRuleElementModelArray = this.getAllHedgeRules();
        int n = 0;
        while (n < hedgeRuleElementModelArray.length) {
            if (hedgeRuleElementModelArray[n].getLabel().equals(string)) {
                return hedgeRuleElementModelArray[n];
            }
            ++n;
        }
        return null;
    }

    public void addHedgeRule(HedgeRuleElementModel hedgeRuleElementModel) {
        if (hedgeRuleElementModel == null) {
            return;
        }
        this.hedgeRules.add(hedgeRuleElementModel);
    }

    public void removeHedgeRule(HedgeRuleElementModel hedgeRuleElementModel) {
        if (hedgeRuleElementModel == null) {
            return;
        }
        this.hedgeRules.remove(hedgeRuleElementModel);
    }

    public HedgeRuleElementModel[] getHedgeRules() {
        return this.getHedgeRules(null);
    }

    public HedgeRuleElementModel[] getHedgeRules(HedgeRuleElementModel hedgeRuleElementModel) {
        ArrayList arrayList = new ArrayList(this.hedgeRules);
        if (hedgeRuleElementModel != null) {
            arrayList.remove(hedgeRuleElementModel);
        }
        HedgeRuleElementModel[] hedgeRuleElementModelArray = new HedgeRuleElementModel[arrayList.size()];
        return arrayList.toArray(hedgeRuleElementModelArray);
    }

    public HedgeRuleElementModel[] getAllHedgeRules() {
        return this.getAllHedgeRules(null);
    }

    public HedgeRuleElementModel[] getAllHedgeRules(HedgeRuleElementModel hedgeRuleElementModel) {
        ArrayList<HedgeRuleElementModel> arrayList = new ArrayList<HedgeRuleElementModel>(Arrays.asList(this.getHedgeRules(hedgeRuleElementModel)));
        ModuleModel[] moduleModelArray = this.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            arrayList.addAll(Arrays.asList(moduleModelArray[n].getHedgeRules(hedgeRuleElementModel)));
            ++n;
        }
        HedgeRuleElementModel[] hedgeRuleElementModelArray = new HedgeRuleElementModel[arrayList.size()];
        return arrayList.toArray(hedgeRuleElementModelArray);
    }

    public void addIncludeModule(ModuleModel moduleModel) {
        if (moduleModel == null) {
            return;
        }
        this.includedModules.add(moduleModel);
    }

    public void removeIncludeModule(ModuleModel moduleModel) {
        if (moduleModel == null) {
            return;
        }
        this.includedModules.remove(moduleModel);
    }

    public ModuleModel[] getIncludeModules() {
        ModuleModel[] moduleModelArray = new ModuleModel[this.includedModules.size()];
        return this.includedModules.toArray(moduleModelArray);
    }

    public String getRelaxCoreVersion() {
        return this.relaxCoreVersion;
    }

    public void setRelaxCoreVersion(String string) {
        this.relaxCoreVersion = string;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(String string) {
        this.moduleVersion = string;
    }

    public String getTargetNameSpace() {
        return this.targetNameSpace;
    }

    public void setTargetNameSpace(String string) {
        this.targetNameSpace = string;
    }

    public String getModuleComment() {
        return this.moduleComment;
    }

    public void setModuleComment(String string) {
        this.moduleComment = string;
    }

    public String getModuleName() {
        if (StringUtil.isNull(this.moduleFilename)) {
            return MainApp.getResString("noFilename");
        }
        File file = new File(this.moduleFilename);
        return file.getName();
    }

    public String getModuleFilename() {
        return this.moduleFilename;
    }

    public void setModuleFilename(String string) {
        this.moduleFilename = string;
    }

    public void modified() {
        this.setModified(true);
    }

    protected void clearModification() {
        this.setModified(false);
    }

    protected void setModified(boolean bl) {
        this.modifiedFlag = bl;
    }

    public boolean isModified() {
        return this.modifiedFlag;
    }

    public boolean canAddElement() {
        return true;
    }

    public void addOpElements(ElementOperation[] elementOperationArray) {
        if (elementOperationArray == null) {
            return;
        }
        int n = 0;
        while (n < elementOperationArray.length) {
            if (elementOperationArray[n] instanceof ObjectModel) {
                this.addRootObject((ObjectModel)elementOperationArray[n]);
            }
            ++n;
        }
    }

    public ElementOperation[] getOpElements() {
        if (this.objects.size() == 0) {
            return null;
        }
        ElementOperation[] elementOperationArray = new ElementOperation[this.objects.size()];
        return this.objects.toArray(elementOperationArray);
    }

    public void removeOpElement(ElementOperation elementOperation) {
        if (elementOperation == null) {
            return;
        }
        if (elementOperation instanceof ObjectModel) {
            this.removeRootObject((ObjectModel)elementOperation);
        }
    }

    public ElementOperation getOpCopy() {
        try {
            MainApp.getAppContext().getMonitor().debug("Module copied.");
            return ModuleModel.relax2module(ModuleModel.module2relax(this), this.getModuleFilename());
        }
        catch (MkRelaxException mkRelaxException) {
            MainApp.getAppContext().getMonitor().recordStackTrace(mkRelaxException);
            return null;
        }
    }

    public int getOpElementLevel() {
        throw new InternalError("Module is top level component. Can not do this operation.(bug)");
    }

    public boolean acceptOpElement(ElementOperation elementOperation) {
        if (elementOperation == null) {
            return false;
        }
        return elementOperation.getOpElementLevel() == 2;
    }

    public String getRelax() {
        return ModuleModel.module2relax(this);
    }

    public static String module2relax(ModuleModel moduleModel, String string, boolean bl) {
        RelaxGenVisitor relaxGenVisitor = new RelaxGenVisitor(string);
        relaxGenVisitor.setForceCorrect(bl);
        VisitorCenter.traverseAllInsideObjects(moduleModel, relaxGenVisitor);
        return relaxGenVisitor.getSource();
    }

    public static String module2relax(ModuleModel moduleModel) {
        return ModuleModel.module2relax(moduleModel, null, false);
    }

    public static ModuleModel relax2module(String string, String string2) throws MkRelaxException {
        return RelaxReader.getModuleFromString(string, string2);
    }

    public static ModuleModel createNewModule() {
        ModuleModel moduleModel = new ModuleModel("", "", "1.0");
        moduleModel.setModuleFilename("");
        return moduleModel;
    }

    public static void saveModuleWithRelax(ModuleModel moduleModel, String string) throws IOException {
        if (StringUtil.isNull(string)) {
            throw new IOException(MainApp.getResString("SaveNullFilename"));
        }
        String string2 = MainApp.getAppContext().getConfig().getOptionString("encoding");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2));
            printWriter.println(ModuleModel.module2relax((ModuleModel)moduleModel.getOpCopy(), string2, true));
            printWriter.flush();
            moduleModel.clearModification();
            Object var5_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    public static ModuleModel loadModuleFromRelax(String string) throws IOException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new IOException(MainApp.getResString("LoadModuleFileNotFound{0}", string));
            }
            ModuleModel moduleModel = RelaxReader.getModuleFromFile(string);
            moduleModel.clearModification();
            return moduleModel;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new IOException(MainApp.getResString("LoadModuleGotRuntimeException") + " : " + runtimeException.getMessage());
        }
        catch (MkRelaxException mkRelaxException) {
            throw new IOException(mkRelaxException.getMessage());
        }
    }
}

