/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.DataType;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;

public class ObjectModel
implements ElementOperation,
AttributeOperation,
Serializable {
    static final long serialVersionUID = -5037952455287831490L;
    ElementModel element;
    String tagName;
    String label;
    String comment;
    DataType type = DataType.RLX_ELEMENT;
    boolean export = false;
    List attributes = new ArrayList();
    ModuleModel parentModule;

    public ObjectModel(ModuleModel moduleModel, String string) {
        this(moduleModel, string, string);
        MainApp.getAppContext().getMonitor().debug("OBJECT:" + this.type);
    }

    public ObjectModel(ModuleModel moduleModel, String string, String string2) {
        this.parentModule = moduleModel;
        this.tagName = string;
        this.label = string2;
    }

    public ModuleModel getParentModule() {
        return this.parentModule;
    }

    public void setType(DataType dataType) {
        if (this.getElement() == null) {
            this.type = dataType;
        } else {
            if (!dataType.equals(DataType.RLX_ELEMENT)) {
                throw new InternalError("Forbidden operation.");
            }
            this.type = DataType.RLX_ELEMENT;
        }
        MainApp.getAppContext().getMonitor().debugStackTrace("OBJECT-:" + this.type);
    }

    public void setType(String string) {
        this.setType(DataType.getTypeByName(string));
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isExportable() {
        return this.export;
    }

    public void setExportable(boolean bl) {
        this.export = bl;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String string) {
        this.tagName = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean isLabelEqTag() {
        return this.tagName.equals(this.label);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setElement(ElementModel elementModel) {
        if (this.getType() != DataType.RLX_ELEMENT) {
            throw new InternalError("Forbidden operation.");
        }
        this.element = elementModel;
    }

    public ElementModel getElement() {
        return this.element;
    }

    public void addAttribute(AttributeModel attributeModel) {
        if (attributeModel == null) {
            return;
        }
        this.attributes.add(attributeModel);
    }

    public void removeAttribute(AttributeModel attributeModel) {
        if (attributeModel == null) {
            return;
        }
        this.attributes.remove(attributeModel);
    }

    public AttributeModel[] getAttributes() {
        AttributeModel[] attributeModelArray = new AttributeModel[this.attributes.size()];
        return this.attributes.toArray(attributeModelArray);
    }

    public int getAttributeNum() {
        return this.attributes.size();
    }

    protected void copyTo(ObjectModel objectModel) {
        objectModel.setTagName(this.getTagName());
        objectModel.setLabel(this.getLabel());
        objectModel.setComment(this.getComment());
        objectModel.setType(this.getType());
        AttributeModel[] attributeModelArray = this.getAttributes();
        int n = 0;
        while (n < attributeModelArray.length) {
            objectModel.addAttribute(attributeModelArray[n].getCopy());
            ++n;
        }
    }

    public boolean canAddElement() {
        return this.getElement() == null && this.getType() == DataType.RLX_ELEMENT;
    }

    public void addOpElements(ElementOperation[] elementOperationArray) {
        if (elementOperationArray == null || elementOperationArray.length == 0) {
            return;
        }
        if (this.acceptOpElement(elementOperationArray[0])) {
            if (elementOperationArray[0] instanceof ElementModel) {
                this.setElement((ElementModel)elementOperationArray[0]);
            } else if (elementOperationArray[0] instanceof ObjectModel) {
                this.setElement(ElementUtil.getRef(this.getParentModule(), (ObjectModel)elementOperationArray[0]));
            } else {
                throw new InternalError("Object is now the subclass of ElementModel.(bug)");
            }
        }
    }

    public ElementOperation[] getOpElements() {
        if (this.getElement() == null) {
            return null;
        }
        ElementOperation[] elementOperationArray = new ElementOperation[]{this.getElement()};
        return elementOperationArray;
    }

    public void removeOpElement(ElementOperation elementOperation) {
        RefElementModel refElementModel;
        if (elementOperation == this.getElement()) {
            this.setElement(null);
            return;
        }
        if (this.getElement() instanceof RefElementModel && (refElementModel = (RefElementModel)this.getElement()).getAt() == elementOperation) {
            this.setElement(null);
            return;
        }
        throw new InternalError("Invalid argument.");
    }

    public ElementOperation getOpCopy() {
        ObjectModel objectModel = ElementUtil.getObject(this.getParentModule(), this.getTagName());
        this.copyTo(objectModel);
        if (this.getOpElements() != null) {
            objectModel.addOpElements(ElementUtil.toArray(this.getOpElements()[0].getOpCopy()));
        }
        return objectModel;
    }

    public int getOpElementLevel() {
        return 2;
    }

    public boolean acceptOpElement(ElementOperation elementOperation) {
        return elementOperation.getOpElementLevel() == 0 || elementOperation.getOpElementLevel() == 1 || elementOperation.getOpElementLevel() == 2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setType(this.type.getTypeName());
    }
}

