/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributePoolModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeRefModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ChoiceElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ConcreteAttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.DataType;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.EmptyElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRuleElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.MixedModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.NoneElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.SequenceElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.VisitorClass;
import jp.gr.java_conf.ccs2.util.StringUtil;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RelaxGenVisitor
extends VisitorClass {
    private Document document = RelaxGenVisitor.newDocument();
    private ModuleModel module;
    private String encoding;
    private Element root;
    private RefElementModel reference;
    private Stack parentStack = new Stack();
    private List wroteObjectList = new ArrayList();
    private boolean forceCorrect = false;

    protected static Document newDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalError(parserConfigurationException.getMessage());
        }
    }

    private Element curParent() {
        return (Element)this.parentStack.peek();
    }

    public RelaxGenVisitor() {
    }

    public RelaxGenVisitor(String string) {
        this.encoding = string;
    }

    public void setForceCorrect(boolean bl) {
        this.forceCorrect = bl;
    }

    public int getAllowedNestedLoop() {
        return 0;
    }

    public boolean isOnlyFirstContact() {
        return true;
    }

    public String getSource() {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = new OutputFormat(this.document);
        if (!StringUtil.isNull(this.encoding)) {
            outputFormat.setEncoding(this.encoding);
        }
        outputFormat.setIndenting(true);
        XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
        try {
            xMLSerializer.serialize(this.document);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException? : " + iOException.getMessage());
        }
        return stringWriter.toString();
    }

    public void start(ModuleModel moduleModel) {
        Object object;
        this.module = moduleModel;
        this.root = this.document.createElement("module");
        this.root.setAttribute("moduleVersion", moduleModel.getModuleVersion());
        this.root.setAttribute("relaxCoreVersion", moduleModel.getRelaxCoreVersion());
        this.root.setAttribute("targetNamespace", moduleModel.getTargetNameSpace());
        this.root.setAttribute("xmlns", "http://www.xml.gr.jp/xmlns/relaxCore");
        this.document.appendChild(this.root);
        Element element = this.appendAnnotationE(this.root, this.module.getModuleComment());
        if (element != null) {
            object = this.document.createElement("appinfo");
            object.appendChild(this.document.createTextNode("ModulePath:" + this.module.getModuleFilename()));
            element.appendChild((Node)object);
        }
        object = this.module.getIncludeModules();
        int n = 0;
        while (n < ((ModuleModel[])object).length) {
            Element element2 = this.document.createElement("include");
            element2.setAttribute("moduleLocation", ((ModuleModel)object[n]).getModuleFilename());
            this.root.appendChild(element2);
            ++n;
        }
    }

    protected Element appendAnnotation(Element element, String string) {
        if (StringUtil.isNull(string)) {
            return null;
        }
        return this.appendAnnotationE(element, string);
    }

    protected Element appendAnnotationE(Element element, String string) {
        if (!MainApp.getAppContext().getConfig().getOption("annotation")) {
            return null;
        }
        Element element2 = this.document.createElement("annotation");
        Element element3 = this.document.createElement("documentation");
        element3.appendChild(this.document.createTextNode(string));
        element2.appendChild(element3);
        element.appendChild(element2);
        return element2;
    }

    public void end(ModuleModel moduleModel) {
        AttributePoolModel[] attributePoolModelArray = this.module.getAttributePools();
        int n = 0;
        while (n < attributePoolModelArray.length) {
            Element element = null;
            if (attributePoolModelArray[n] instanceof AttributePoolModel) {
                AttributePoolModel attributePoolModel = attributePoolModelArray[n];
                element = this.document.createElement("attPool");
                this.appendAnnotation(element, attributePoolModel.getComment());
                element.setAttribute("role", attributePoolModel.getRole());
                AttributeModel[] attributeModelArray = attributePoolModel.getAttributes();
                int n2 = 0;
                while (n2 < attributeModelArray.length) {
                    this.appendAttribute(this.document, element, attributeModelArray[n2]);
                    ++n2;
                }
            } else {
                throw new InternalError("No such attribute. [" + attributePoolModelArray[n].getClass().getName() + " : " + attributePoolModelArray[n] + "]");
            }
            this.root.appendChild(element);
            ++n;
        }
    }

    public void root(ObjectModel objectModel) {
        ObjectModel[] objectModelArray = this.module.getExportableObjects();
        Element element = this.document.createElement("interface");
        int n = 0;
        while (n < objectModelArray.length) {
            Element element2 = this.document.createElement("export");
            element2.setAttribute("label", objectModelArray[n].getLabel());
            element.appendChild(element2);
            ++n;
        }
        this.root.appendChild(element);
        this.parentStack.push(this.root);
    }

    public void objectEnter(ObjectModel objectModel, int n) {
        if (this.wroteObjectList.contains(objectModel)) {
            throw new InternalError("Second Encounterd:" + objectModel);
        }
        if (objectModel.getType() == DataType.RLX_ELEMENT && objectModel.getElement() == null && this.forceCorrect) {
            objectModel.setType(DataType.DEFAULT_TYPE);
        }
        if (objectModel.isLabelEqTag() && objectModel.getType() != DataType.RLX_ELEMENT && objectModel.getElement() == null && this.reference != null && objectModel.getAttributeNum() == 0 && ElementUtil.getReferencesToMe(this.module, objectModel).length == 1) {
            Element element = this.document.createElement("element");
            this.appendAnnotation(element, objectModel.getComment());
            element.setAttribute("name", objectModel.getTagName());
            element.setAttribute("type", objectModel.getType().getTypeName());
            if (this.reference.getOccurs() != 0) {
                element.setAttribute("occurs", this.reference.getOccurSymbol());
            }
            this.curParent().appendChild(element);
            this.parentStack.push(element);
        } else {
            Element element;
            if (this.reference != null) {
                element = this.document.createElement("ref");
                element.setAttribute("label", this.reference.getAt().getLabel());
                this.setupOccus(element, this.reference);
                this.curParent().appendChild(element);
            }
            element = this.document.createElement("elementRule");
            this.appendAnnotation(element, objectModel.getComment());
            Element element2 = this.document.createElement("tag");
            if (!objectModel.isLabelEqTag()) {
                element2.setAttribute("name", objectModel.getTagName());
            }
            AttributeModel[] attributeModelArray = objectModel.getAttributes();
            int n2 = 0;
            while (n2 < attributeModelArray.length) {
                this.appendAttribute(this.document, element2, attributeModelArray[n2]);
                ++n2;
            }
            element.appendChild(element2);
            element.setAttribute("label", objectModel.getLabel());
            if (objectModel.getType() != DataType.RLX_ELEMENT) {
                element.setAttribute("type", objectModel.getType().getTypeName());
            }
            this.root.appendChild(element);
            this.parentStack.push(element);
        }
        this.reference = null;
    }

    public void objectExit(ObjectModel objectModel) {
        if (this.wroteObjectList.contains(objectModel)) {
            return;
        }
        this.parentStack.pop();
        this.wroteObjectList.add(objectModel);
    }

    public void hedgeRuleEnter(HedgeRuleElementModel hedgeRuleElementModel) {
        Element element = this.document.createElement("hedgeRule");
        element.setAttribute("label", hedgeRuleElementModel.getLabel());
        this.appendAnnotation(element, hedgeRuleElementModel.getComment());
        this.root.appendChild(element);
        this.parentStack.push(element);
    }

    public void hedgeRuleExit(HedgeRuleElementModel hedgeRuleElementModel) {
        this.parentStack.pop();
    }

    void appendAttribute(Document document, Element element, AttributeModel attributeModel) {
        Element element2 = null;
        if (attributeModel instanceof ConcreteAttributeModel) {
            ConcreteAttributeModel concreteAttributeModel = (ConcreteAttributeModel)attributeModel;
            element2 = this.document.createElement("attribute");
            this.appendAnnotation(element2, concreteAttributeModel.getComment());
            element2.setAttribute("name", concreteAttributeModel.getName());
            element2.setAttribute("type", concreteAttributeModel.getType().getTypeName());
            if (concreteAttributeModel.isRequired()) {
                element2.setAttribute("required", "true");
            }
        } else if (attributeModel instanceof AttributeRefModel) {
            AttributeRefModel attributeRefModel = (AttributeRefModel)attributeModel;
            element2 = this.document.createElement("ref");
            element2.setAttribute("role", attributeRefModel.getAt().getRole());
        } else {
            throw new InternalError("No such attribute. [" + attributeModel.getClass().getName() + " : " + attributeModel + "]");
        }
        element.appendChild(element2);
    }

    public void mixedEnter(MixedModel mixedModel) {
        Element element = this.document.createElement("mixed");
        this.curParent().appendChild(element);
        this.parentStack.push(element);
    }

    public void mixedExit(MixedModel mixedModel) {
        this.parentStack.pop();
    }

    public void none(NoneElementModel noneElementModel) {
        this.curParent().appendChild(this.document.createElement("none"));
    }

    public void empty(EmptyElementModel emptyElementModel) {
        this.curParent().appendChild(this.document.createElement("empty"));
    }

    public void choiceEnter(ChoiceElementModel choiceElementModel) {
        Element element = this.document.createElement("choice");
        this.setupOccus(element, choiceElementModel);
        this.curParent().appendChild(element);
        this.parentStack.push(element);
    }

    public void choiceExit(ChoiceElementModel choiceElementModel) {
        this.parentStack.pop();
    }

    public void sequenceEnter(SequenceElementModel sequenceElementModel) {
        Element element = this.document.createElement("sequence");
        this.setupOccus(element, sequenceElementModel);
        this.curParent().appendChild(element);
        this.parentStack.push(element);
    }

    public void sequenceExit(SequenceElementModel sequenceElementModel) {
        this.parentStack.pop();
    }

    public void hedgeRef(HedgeRefElementModel hedgeRefElementModel) {
        Element element = this.document.createElement("hedgeRef");
        element.setAttribute("label", hedgeRefElementModel.getAt().getLabel());
        this.setupOccus(element, hedgeRefElementModel);
        this.curParent().appendChild(element);
    }

    public void ref(RefElementModel refElementModel) {
        if (refElementModel.getAt() != null && (refElementModel.getAt().getParentModule() != this.module || ElementUtil.getReferencesToMe(this.module, refElementModel.getAt()).length > 1)) {
            Element element = this.document.createElement("ref");
            element.setAttribute("label", refElementModel.getAt().getLabel());
            this.setupOccus(element, refElementModel);
            this.curParent().appendChild(element);
            return;
        }
        this.reference = refElementModel;
    }

    private void setupOccus(Element element, AbstractElementModel abstractElementModel) {
        if (abstractElementModel.getOccurs() != 0) {
            element.setAttribute("occurs", abstractElementModel.getOccurSymbol());
        }
    }
}

