/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributePoolModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeRefModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ConcreteAttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRuleElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.MixedModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MkRelaxException;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.xml.relax.sax.RELAXEntityResolver;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RelaxReader {
    ModuleModel moduleModel;
    ModuleModel oldModule;
    List reloadEntries;
    HashMap tagNodeTable = new HashMap();
    HashMap ruleTable = new HashMap();
    HashMap tagTable = new HashMap();
    HashMap attPoolTable = new HashMap();
    HashMap hedgeRuleTable = new HashMap();
    List refList = new ArrayList();
    String curPath;
    Stack pathStack = new Stack();

    protected RelaxReader() {
    }

    public static ModuleModel getModuleWithReloading(ModuleModel moduleModel, List list) throws MkRelaxException {
        RelaxReader relaxReader = new RelaxReader();
        relaxReader.setupModuleWithReloading(moduleModel, list);
        return relaxReader.getModule();
    }

    protected void setupModuleWithReloading(ModuleModel moduleModel, List list) throws MkRelaxException {
        this.oldModule = moduleModel;
        this.setCurrentPath(this.oldModule.getModuleFilename());
        this.reloadEntries = list;
        this.setupModuleCommon(this.readDocumentFromString(moduleModel.getRelax()));
    }

    public static ModuleModel getModuleFromFile(String string) throws MkRelaxException {
        RelaxReader relaxReader = new RelaxReader();
        relaxReader.setupModuleFromFile(string);
        return relaxReader.getModule();
    }

    protected void setupModuleFromFile(String string) throws MkRelaxException {
        this.setCurrentPath(string);
        this.setupModuleCommon(this.readDocumentFromFile(string));
    }

    public static ModuleModel getModuleFromString(String string, String string2) throws MkRelaxException {
        RelaxReader relaxReader = new RelaxReader();
        relaxReader.setupModuleFromString(string, string2);
        return relaxReader.getModule();
    }

    public void setupModuleFromString(String string, String string2) throws MkRelaxException {
        this.setCurrentPath(string2);
        this.setupModuleCommon(this.readDocumentFromString(string));
    }

    protected void setupModuleCommon(Document document) throws MkRelaxException {
        try {
            this.pathStack.push("bottom");
            this.expandRelax(document);
            this.buildModule(document);
            if (this.pathStack.size() != 1) {
                throw new InternalError("Wrong number of stacked objects(bug) : " + this.pathStack.size());
            }
        }
        catch (RuntimeException runtimeException) {
            this.throwException(this.format("RelaxSyntaxError", runtimeException.getMessage()));
        }
    }

    protected ModuleModel getModule() {
        MainApp.getAppContext().getMonitor().debug("READER:" + RelaxReader.getDumpModule(this.moduleModel));
        return this.moduleModel;
    }

    void buildModule(Document document) throws MkRelaxException {
        Element element = document.getDocumentElement();
        this.setupModule(element);
        this.prepareTables(element);
        this.setupInterface(element);
        this.includeModules(element);
        this.setupElementRules(element);
        this.setupHedgeRules(element);
        this.setupAttPools(element);
        this.findRoots();
    }

    /*
     * Unable to fully structure code
     */
    void includeModules(Element var1_1) throws MkRelaxException {
        var2_2 = this.getElementsByTagName(var1_1, "include");
        var3_3 = 0;
        while (var3_3 < var2_2.length) {
            var4_4 = var2_2[var3_3].getAttribute("moduleLocation");
            if (StringUtil.isNull(var4_4)) {
                this.throwException(this.format("ModuleLocationIsNull{0}", var2_2[var3_3]));
            }
            if (this.oldModule == null) ** GOTO lbl-1000
            var5_5 = this.getOldModuleByLocation(var4_4);
            if (var5_5 == null) {
                this.throwException(this.format("Module object has gone! : {0}", var4_4));
            }
            if (this.reloadEntries != null && !this.reloadEntries.contains(var5_5)) {
                this.moduleModel.addIncludeModule(RelaxReader.getModuleWithReloading(var5_5, this.reloadEntries));
                MainApp.getAppContext().getMonitor().debug("READER : rebuild module [" + var4_4 + "]");
            } else lbl-1000:
            // 2 sources

            {
                try {
                    this.moduleModel.addIncludeModule(ModuleModel.loadModuleFromRelax(this.transCanonicalPath(var4_4)));
                    MainApp.getAppContext().getMonitor().debug("READER : loaded from [" + var4_4 + "]");
                }
                catch (IOException var5_6) {
                    this.throwException(var5_6.getMessage());
                }
            }
            ++var3_3;
        }
    }

    ModuleModel getOldModuleByLocation(String string) throws MkRelaxException {
        ModuleModel[] moduleModelArray = this.oldModule.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            if (moduleModelArray[n].getModuleFilename().equals(string)) {
                return moduleModelArray[n];
            }
            ++n;
        }
        this.throwException("Module not found : " + string);
        return null;
    }

    void setCurrentPath(String string) {
        MainApp.getAppContext().getMonitor().debug("SetCurrentPath:" + string + " (<-" + this.getCurrentPath() + ")");
        this.curPath = StringUtil.isNull(string) ? System.getProperty("user.dir") : string;
    }

    String getCurrentPath() {
        if (StringUtil.isNull(this.curPath)) {
            return System.getProperty("user.dir");
        }
        return this.curPath;
    }

    String getCurrentParentPath() {
        if (StringUtil.isNull(this.curPath)) {
            return System.getProperty("user.dir");
        }
        return new File(this.curPath).getParent();
    }

    String transCanonicalPath(String string) throws MkRelaxException {
        File file = new File(string);
        if (file.exists()) {
            return string;
        }
        file = new File(this.getCurrentParentPath(), string);
        if (file.exists()) {
            return file.getPath();
        }
        this.throwException(this.format("ModuleFile{0}NotFound", string));
        return null;
    }

    void prepareTables(Element element) throws MkRelaxException {
        Object object;
        Object object2;
        Object object3;
        Element[] elementArray = this.getElementsByTagName(element, "elementRule");
        int n = 0;
        while (n < elementArray.length) {
            object3 = this.getLabelOfElement(elementArray[n]);
            ObjectModel objectModel = ElementUtil.getObject(this.moduleModel, (String)object3);
            this.ruleTable.put(this.getLabelOfElement(elementArray[n]), objectModel);
            this.tagTable.put(this.getRoleOfElement(elementArray[n]), objectModel);
            ++n;
        }
        object3 = this.getElementsByTagName(element, "tag");
        int n2 = 0;
        while (n2 < ((Element[])object3).length) {
            object2 = this.getRoleOfTag(object3[n2]);
            this.tagNodeTable.put(object2, object3[n2]);
            this.getObjectByRole((String)object2).setTagName(this.getNameOfTag(object3[n2]));
            ++n2;
        }
        object2 = this.getElementsByTagName(element, "attPool");
        int n3 = 0;
        while (n3 < ((Element[])object2).length) {
            object = this.getRoleOfAttPool(object2[n3]);
            this.attPoolTable.put(object, ElementUtil.getAttributePool((String)object));
            ++n3;
        }
        object = this.getElementsByTagName(element, "hedgeRule");
        int n4 = 0;
        while (n4 < ((Element[])object).length) {
            String string = this.getLabelOfHedgeRule(object[n4]);
            this.hedgeRuleTable.put(string, ElementUtil.getHedgeRule(this.moduleModel, string));
            ++n4;
        }
    }

    void setupModule(Element element) throws MkRelaxException {
        this.moduleModel = ModuleModel.createNewModule();
        this.moduleModel.setModuleVersion(element.getAttribute("moduleVersion"));
        this.moduleModel.setRelaxCoreVersion(element.getAttribute("relaxCoreVersion"));
        this.moduleModel.setTargetNameSpace(element.getAttribute("targetNamespace"));
        this.moduleModel.setModuleVersion(element.getAttribute("moduleVersion"));
        this.moduleModel.setModuleFilename(this.getCurrentPath());
        this.moduleModel.setModuleComment(this.getDocumentation(element));
    }

    void setupInterface(Element element) throws MkRelaxException {
        this.pathStack.push("interface");
        Element[] elementArray = this.getElementsByTagName(element, "interface");
        if (elementArray != null && elementArray.length > 0) {
            Element[] elementArray2 = this.getElementsByTagName(elementArray[0], "export");
            int n = 0;
            while (n < elementArray2.length) {
                String string = elementArray2[n].getAttribute("label");
                ObjectModel objectModel = this.getObjectByLabel(string);
                objectModel.setExportable(true);
                ++n;
            }
        }
        this.pathStack.pop();
    }

    String getAppinfo(String string, Element element) {
        String string2 = this.getAnnotationTag(element, "appinfo");
        if (!StringUtil.isNull(string2) && string2.indexOf(string) != -1) {
            return string2.substring(string.length());
        }
        return null;
    }

    String getDocumentation(Element element) {
        return this.getAnnotationTag(element, "documentation");
    }

    private String getAnnotationTag(Element element, String string) {
        Element[] elementArray;
        Element[] elementArray2 = this.getElementsByTagName(element, "annotation");
        if (elementArray2 != null && elementArray2.length != 0 && (elementArray = this.getElementsByTagName(elementArray2[0], string)) != null && elementArray.length > 0 && elementArray[0].getFirstChild() != null) {
            return elementArray[0].getFirstChild().getNodeValue();
        }
        return null;
    }

    void findRoots() {
        String[] stringArray = new String[this.refList.size()];
        stringArray = this.refList.toArray(stringArray);
        int n = 0;
        while (n < stringArray.length) {
            this.ruleTable.remove(stringArray[n]);
            ++n;
        }
        Iterator iterator = this.ruleTable.values().iterator();
        while (iterator.hasNext()) {
            ObjectModel objectModel = (ObjectModel)iterator.next();
            this.moduleModel.addRootObject(objectModel);
        }
    }

    void setupElementRules(Element element) throws MkRelaxException {
        this.pathStack.push("elementRules");
        Element[] elementArray = this.getElementsByTagName(element, "elementRule");
        int n = 0;
        while (n < elementArray.length) {
            String string = this.getLabelOfElement(elementArray[n]);
            ObjectModel objectModel = this.getObjectByLabel(string);
            objectModel.setComment(this.getDocumentation(elementArray[n]));
            String string2 = elementArray[n].getAttribute("type");
            if (!StringUtil.isNull(string2)) {
                objectModel.setType(string2);
            } else {
                this.setupElements(elementArray[n], objectModel);
            }
            this.setupAttributes(elementArray[n], objectModel);
            ++n;
        }
        this.pathStack.pop();
    }

    void setupHedgeRules(Element element) throws MkRelaxException {
        this.pathStack.push("hedgeRules");
        Element[] elementArray = this.getElementsByTagName(element, "hedgeRule");
        int n = 0;
        while (n < elementArray.length) {
            String string = this.getLabelOfHedgeRule(elementArray[n]);
            HedgeRuleElementModel hedgeRuleElementModel = this.getHedgeRuleByLabel(string);
            hedgeRuleElementModel.setComment(this.getDocumentation(elementArray[n]));
            this.moduleModel.addHedgeRule(hedgeRuleElementModel);
            this.setupHedgeElement(elementArray[n], hedgeRuleElementModel);
            ++n;
        }
        this.pathStack.pop();
    }

    void setupElements(Element element, ElementOperation elementOperation) throws MkRelaxException {
        Element[] elementArray = this.getElementsByTagName(element, "mixed");
        if (elementArray != null && elementArray.length > 0) {
            this.pathStack.push("mixed");
            MixedModel mixedModel = ElementUtil.getMixed(this.moduleModel);
            elementOperation.addOpElements(ElementUtil.toArray(mixedModel));
            this.setupHedgeElement(elementArray[0], mixedModel);
            this.pathStack.pop();
        } else {
            this.setupHedgeElement(element, elementOperation);
        }
    }

    void setupHedgeElement(Element element, ElementOperation elementOperation) throws MkRelaxException {
        Element[] elementArray = this.getChildElements(element);
        if (elementArray == null && elementArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < elementArray.length) {
            AbstractElementModel abstractElementModel;
            ElementOperation elementOperation2;
            Object object;
            if (elementArray[n].getTagName().equals("ref")) {
                this.pathStack.push("ref[" + n + "]");
                object = elementArray[n].getAttribute("label");
                elementOperation2 = this.getObjectByLabel((String)object);
                abstractElementModel = ElementUtil.getRef(this.moduleModel, elementOperation2);
                this.refList.add(object);
                this.setupOccurs(elementArray[n], abstractElementModel);
                elementOperation.addOpElements(ElementUtil.toArray(abstractElementModel));
                this.pathStack.pop();
            } else if (elementArray[n].getTagName().equals("hedgeRef")) {
                this.pathStack.push("hedgeRef[" + n + "]");
                object = elementArray[n].getAttribute("label");
                elementOperation2 = this.getHedgeRuleByLabel((String)object);
                abstractElementModel = ElementUtil.getHedgeRef(this.moduleModel, (HedgeRuleElementModel)elementOperation2);
                this.setupOccurs(elementArray[n], abstractElementModel);
                elementOperation.addOpElements(ElementUtil.toArray(abstractElementModel));
                this.pathStack.pop();
            } else if (elementArray[n].getTagName().equals("none")) {
                elementOperation.addOpElements(ElementUtil.toArray(ElementUtil.getNone(this.moduleModel)));
            } else if (elementArray[n].getTagName().equals("empty")) {
                elementOperation.addOpElements(ElementUtil.toArray(ElementUtil.getEmpty(this.moduleModel)));
            } else if (elementArray[n].getTagName().equals("choice")) {
                this.pathStack.push("choice[" + n + "]");
                object = ElementUtil.getChoice(this.moduleModel);
                this.setupOccurs(elementArray[n], (AbstractElementModel)object);
                elementOperation.addOpElements(ElementUtil.toArray((ElementOperation)object));
                this.setupHedgeElement(elementArray[n], (ElementOperation)object);
                this.pathStack.pop();
            } else if (elementArray[n].getTagName().equals("sequence")) {
                this.pathStack.push("sequence[" + n + "]");
                object = ElementUtil.getSequence(this.moduleModel);
                this.setupOccurs(elementArray[n], (AbstractElementModel)object);
                elementOperation.addOpElements(ElementUtil.toArray((ElementOperation)object));
                this.setupHedgeElement(elementArray[n], (ElementOperation)object);
                this.pathStack.pop();
            }
            ++n;
        }
    }

    void setupOccurs(Element element, AbstractElementModel abstractElementModel) {
        if (!StringUtil.isNull(element.getAttribute("occurs"))) {
            abstractElementModel.setOccurs(element.getAttribute("occurs"));
        }
    }

    void setupAttributes(Element element, ObjectModel objectModel) throws MkRelaxException {
        this.pathStack.push(objectModel.getTagName() + "(tag)");
        Element element2 = (Element)this.tagNodeTable.get(this.getRoleOfElement(element));
        AttributeModel[] attributeModelArray = this.getAttributes(element2);
        int n = 0;
        while (n < attributeModelArray.length) {
            objectModel.addAttribute(attributeModelArray[n]);
            ++n;
        }
        this.pathStack.pop();
    }

    void setupAttPools(Element element) throws MkRelaxException {
        this.pathStack.push("attPools");
        Element[] elementArray = this.getElementsByTagName(element, "attPool");
        int n = 0;
        while (n < elementArray.length) {
            String string = this.getRoleOfAttPool(elementArray[n]);
            AttributePoolModel attributePoolModel = this.getAttPoolByRole(string);
            attributePoolModel.setComment(this.getDocumentation(elementArray[n]));
            this.moduleModel.addAttributePool(attributePoolModel);
            AttributeModel[] attributeModelArray = this.getAttributes(elementArray[n]);
            int n2 = 0;
            while (n2 < attributeModelArray.length) {
                attributePoolModel.addAttribute(attributeModelArray[n2]);
                ++n2;
            }
            ++n;
        }
        this.pathStack.pop();
    }

    AttributeModel[] getAttributes(Element element) throws MkRelaxException {
        Serializable serializable;
        Object object;
        Object object2;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        Element[] elementArray = this.getElementsByTagName(element, "attribute");
        int n = 0;
        while (n < elementArray.length) {
            object2 = elementArray[n].getAttribute("name");
            String string = elementArray[n].getAttribute("type");
            object = elementArray[n].getAttribute("required");
            if (StringUtil.isNull((String)object2)) {
                this.throwException(this.format("NameNotFound{0}", elementArray[n]));
            }
            if (StringUtil.isNull(string)) {
                this.throwException(this.format("TypeNotFound{0}", elementArray[n]));
            }
            serializable = ElementUtil.getAttribute((String)object2);
            ((ConcreteAttributeModel)serializable).setType(string);
            if (StringUtil.isNull((String)object)) {
                ((ConcreteAttributeModel)serializable).setRequired(false);
            }
            ((ConcreteAttributeModel)serializable).setComment(this.getDocumentation(elementArray[n]));
            arrayList.add(serializable);
            ++n;
        }
        object2 = this.getElementsByTagName(element, "ref");
        int n2 = 0;
        while (n2 < ((Element[])object2).length) {
            object = object2[n2].getAttribute("role");
            serializable = this.getAttPoolByRole((String)object);
            AttributeRefModel attributeRefModel = ElementUtil.getAttributeRef((AttributePoolModel)serializable);
            arrayList.add(attributeRefModel);
            ++n2;
        }
        object = new AttributeModel[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    String getLabelOfElement(Element element) throws MkRelaxException {
        String string = element.getAttribute("label");
        if (StringUtil.isNull(string)) {
            string = element.getAttribute("role");
        }
        if (StringUtil.isNull(string)) {
            this.throwException(this.format("RoleNotFound{0}", element));
        }
        return string;
    }

    String getRoleOfElement(Element element) throws MkRelaxException {
        String string = element.getAttribute("role");
        if (StringUtil.isNull(string)) {
            this.throwException(this.format("RoleNotFound{0}", element));
        }
        return string;
    }

    String getNameOfTag(Element element) throws MkRelaxException {
        String string = element.getAttribute("name");
        if (StringUtil.isNull(string)) {
            this.throwException(this.format("NameNotFound{0}", element));
        }
        return string;
    }

    String getRoleOfTag(Element element) throws MkRelaxException {
        String string = element.getAttribute("role");
        if (StringUtil.isNull(string)) {
            string = element.getAttribute("name");
        }
        if (StringUtil.isNull(string)) {
            this.throwException(this.format("NameNotFound{0}", element));
        }
        return string;
    }

    String getRoleOfAttPool(Element element) throws MkRelaxException {
        String string = element.getAttribute("role");
        if (StringUtil.isNull(string)) {
            this.throwException(this.format("RoleNotFound{0}", element));
        }
        return string;
    }

    String getLabelOfHedgeRule(Element element) throws MkRelaxException {
        String string = element.getAttribute("label");
        if (StringUtil.isNull(string)) {
            this.throwException(this.format("LabelNot{0}Found", element));
        }
        return string;
    }

    ObjectModel getObjectByRole(String string) throws MkRelaxException {
        ObjectModel objectModel = (ObjectModel)this.tagTable.get(string);
        if (objectModel == null) {
            this.throwException(this.format("ElementTag{0}NotFound", string));
        }
        return objectModel;
    }

    ObjectModel getObjectByLabel(String string) throws MkRelaxException {
        ObjectModel objectModel = (ObjectModel)this.ruleTable.get(string);
        if (objectModel == null) {
            objectModel = this.getObjectByLabelFromIncluded(string);
        }
        if (objectModel == null) {
            this.throwException(this.format("ElementRule{0}NotFound", string));
        }
        return objectModel;
    }

    ObjectModel getObjectByLabelFromIncluded(String string) {
        ModuleModel[] moduleModelArray = this.moduleModel.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            ObjectModel objectModel = moduleModelArray[n].getObjectByLabel(string);
            if (objectModel != null) {
                return objectModel;
            }
            ++n;
        }
        return null;
    }

    HedgeRuleElementModel getHedgeRuleByLabel(String string) throws MkRelaxException {
        HedgeRuleElementModel hedgeRuleElementModel = (HedgeRuleElementModel)this.hedgeRuleTable.get(string);
        if (hedgeRuleElementModel == null) {
            hedgeRuleElementModel = this.getHedgeRuleByLabelFromIncluded(string);
        }
        if (hedgeRuleElementModel == null) {
            this.throwException(this.format("HedgeRule{0}NotFound", string));
        }
        return hedgeRuleElementModel;
    }

    HedgeRuleElementModel getHedgeRuleByLabelFromIncluded(String string) {
        ModuleModel[] moduleModelArray = this.moduleModel.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            HedgeRuleElementModel hedgeRuleElementModel = moduleModelArray[n].getHedgeRuleByLabel(string);
            if (hedgeRuleElementModel != null) {
                return hedgeRuleElementModel;
            }
            ++n;
        }
        return null;
    }

    AttributePoolModel getAttPoolByRole(String string) throws MkRelaxException {
        AttributePoolModel attributePoolModel = (AttributePoolModel)this.attPoolTable.get(string);
        if (attributePoolModel == null) {
            attributePoolModel = this.getAttPoolByRoleFromIncluded(string);
        }
        if (attributePoolModel == null) {
            this.throwException(this.format("AttPool{0}NotFound", string));
        }
        return attributePoolModel;
    }

    AttributePoolModel getAttPoolByRoleFromIncluded(String string) {
        ModuleModel[] moduleModelArray = this.moduleModel.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            AttributePoolModel attributePoolModel = moduleModelArray[n].getAttributePoolByRole(string);
            if (attributePoolModel != null) {
                return attributePoolModel;
            }
            ++n;
        }
        return null;
    }

    void expandRelax(Document document) throws MkRelaxException {
        Element element = document.getDocumentElement();
        Element[] elementArray = this.getElementsByTagName(element, "elementRule");
        int n = 0;
        while (n < elementArray.length) {
            this.expandElementGen(document, element, elementArray[n]);
            ++n;
        }
        elementArray = this.getElementsByTagName(element, "hedgeRule");
        int n2 = 0;
        while (n2 < elementArray.length) {
            this.expandElementGen(document, element, elementArray[n2]);
            ++n2;
        }
        elementArray = this.getElementsByTagName(element, "elementRule");
        int n3 = 0;
        while (n3 < elementArray.length) {
            Element[] elementArray2 = this.getElementsByTagName(elementArray[n3], "tag");
            if (elementArray2.length > 0) {
                this.expandTag(document, element, elementArray[n3], elementArray2[0]);
            }
            ++n3;
        }
    }

    void expandTag(Document document, Element element, Element element2, Element element3) throws MkRelaxException {
        Element element4 = document.createElement("tag");
        if (StringUtil.isNull(element3.getAttribute("name"))) {
            element4.setAttribute("name", this.getLabelOfElement(element2));
        } else {
            element4.setAttribute("name", element3.getAttribute("name"));
        }
        String string = this.getUniqueRole(element, this.getLabelOfElement(element2));
        element4.setAttribute("role", string);
        element2.setAttribute("role", string);
        Element[] elementArray = this.getChildElements(element3);
        int n = 0;
        while (n < elementArray.length) {
            Element element5 = null;
            if (elementArray[n].getTagName().equals("attribute")) {
                element5 = document.createElement("attribute");
                element5.setAttribute("name", elementArray[n].getAttribute("name"));
                element5.setAttribute("type", elementArray[n].getAttribute("type"));
                if (!StringUtil.isNull(elementArray[n].getAttribute("required"))) {
                    element5.setAttribute("required", elementArray[n].getAttribute("required"));
                }
                this.appendAnnotation(document, element5, this.getDocumentation(elementArray[n]));
            } else if (elementArray[n].getTagName().equals("ref")) {
                element5 = document.createElement("ref");
                element5.setAttribute("role", elementArray[n].getAttribute("role"));
            } else {
                this.throwException(this.format("WrongTag{0}", elementArray[n]));
            }
            element4.appendChild(element5);
            ++n;
        }
        element2.removeChild(element3);
        element.appendChild(element4);
    }

    void expandElementGen(Document document, Element element, Element element2) {
        this.expandElement(document, element, element2);
        Element[] elementArray = this.getChildElements(element2);
        int n = 0;
        while (n < elementArray.length) {
            if (elementArray[n].getNodeName().equals("sequence") || elementArray[n].getNodeName().equals("choice") || elementArray[n].getNodeName().equals("mixed")) {
                this.expandElementGen(document, element, elementArray[n]);
            }
            ++n;
        }
    }

    void expandElement(Document document, Element element, Element element2) {
        Element[] elementArray = this.getElementsByTagName(element2, "element");
        if (elementArray.length > 0) {
            int n = 0;
            while (n < elementArray.length) {
                Element element3 = document.createElement("ref");
                String string = this.getUniqueLabel(element, elementArray[n].getAttribute("name"));
                element3.setAttribute("label", string);
                if (!StringUtil.isNull(elementArray[n].getAttribute("occurs"))) {
                    element3.setAttribute("occurs", elementArray[n].getAttribute("occurs"));
                }
                element2.appendChild(element3);
                element2.removeChild(elementArray[n]);
                Element element4 = document.createElement("elementRule");
                this.appendAnnotation(document, element4, this.getDocumentation(elementArray[n]));
                element4.setAttribute("label", string);
                element4.setAttribute("role", string);
                element4.setAttribute("type", elementArray[n].getAttribute("type"));
                element.appendChild(element4);
                Element element5 = document.createElement("tag");
                element5.setAttribute("name", elementArray[n].getAttribute("name"));
                element5.setAttribute("role", string);
                element.appendChild(element5);
                ++n;
            }
        } else {
            Element[] elementArray2 = this.getChildElements(element2);
            int n = 0;
            while (n < elementArray2.length) {
                this.expandElement(document, element, elementArray2[n]);
                ++n;
            }
        }
    }

    protected Element appendAnnotation(Document document, Element element, String string) {
        Element element2 = document.createElement("annotation");
        Element element3 = document.createElement("documentation");
        element3.appendChild(document.createTextNode(string));
        element2.appendChild(element3);
        element.appendChild(element2);
        return element2;
    }

    Element[] getElementsByTagName(Element element, String string) {
        Element[] elementArray = this.getChildElements(element);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = 0;
        while (n < elementArray.length) {
            if (elementArray[n].getNodeName().equals(string)) {
                arrayList.add(elementArray[n]);
            }
            ++n;
        }
        Element[] elementArray2 = new Element[arrayList.size()];
        return arrayList.toArray(elementArray2);
    }

    Element[] getChildElements(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                arrayList.add(nodeList.item(n));
            }
            ++n;
        }
        Element[] elementArray = new Element[arrayList.size()];
        return arrayList.toArray(elementArray);
    }

    Document readDocumentFromFile(String string) throws MkRelaxException {
        try {
            return this.getDocumentBuilder().parse(new File(string));
        }
        catch (RuntimeException runtimeException) {
            this.throwException(MainApp.getResString("RelaxSyntaxError") + " : " + runtimeException.getMessage());
        }
        catch (SAXException sAXException) {
            this.throwException(MainApp.getResString("XMLException") + " : " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            this.throwException(MainApp.getResString("RelaxIOException") + " : " + iOException.getMessage());
        }
        return null;
    }

    Document readDocumentFromString(String string) throws MkRelaxException {
        try {
            return this.getDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (RuntimeException runtimeException) {
            this.throwException(MainApp.getResString("RelaxSyntaxError") + " : " + runtimeException.getMessage());
        }
        catch (SAXException sAXException) {
            this.throwException(MainApp.getResString("XMLException") + " : " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            this.throwException(MainApp.getResString("RelaxIOException") + " : " + iOException.getMessage());
        }
        return null;
    }

    DocumentBuilder getDocumentBuilder() throws MkRelaxException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new RELAXEntityResolver());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.throwException(MainApp.getResString("ParseConfigurationException") + " : " + parserConfigurationException.getMessage());
            return null;
        }
    }

    String getUniqueLabel(Element element, String string) {
        String string2 = string;
        long l = 0L;
        while (!(this.isUnique(element, "element", "label", string2) && this.isUnique(element, "elementRule", "label", string2) && this.isUnique(element, "hedgeRule", "label", string2))) {
            string2 = string + "_" + l;
        }
        return string2;
    }

    String getUniqueRole(Element element, String string) {
        String string2 = string;
        long l = 0L;
        while (!this.isUnique(element, "attPool", "role", string2) || !this.isUnique(element, "tag", "role", string2)) {
            string2 = string + "_" + l;
            if (l <= 20L) continue;
            MainApp.getAppContext().getMonitor().warning("too many non-unique roles. : " + string);
        }
        return string2;
    }

    boolean isUnique(Element element, String string, String string2, String string3) {
        Element[] elementArray = this.getAllElement(element, string);
        int n = 0;
        while (n < elementArray.length) {
            String string4 = elementArray[n].getAttribute(string2);
            if (string4.equals(string3)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    Element[] getAllElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                arrayList.add(nodeList.item(n));
            }
            ++n;
        }
        Element[] elementArray = new Element[arrayList.size()];
        return arrayList.toArray(elementArray);
    }

    public static String getDumpModule(ModuleModel moduleModel) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("module:" + moduleModel.getModuleName()).append("\n");
        stringBuffer.append("filename:" + moduleModel.getModuleFilename()).append("\n");
        ObjectModel[] objectModelArray = moduleModel.getExportableObjects();
        int n = 0;
        while (n < objectModelArray.length) {
            stringBuffer.append("export:" + objectModelArray[n].getLabel()).append("\n");
            ++n;
        }
        objectModelArray = moduleModel.getObjects();
        int n2 = 0;
        while (n2 < objectModelArray.length) {
            stringBuffer.append("element:" + objectModelArray[n2].getLabel()).append("\n");
            ++n2;
        }
        HedgeRuleElementModel[] hedgeRuleElementModelArray = moduleModel.getHedgeRules();
        int n3 = 0;
        while (n3 < hedgeRuleElementModelArray.length) {
            stringBuffer.append("hedgeRule:" + hedgeRuleElementModelArray[n3].getLabel()).append("\n");
            ++n3;
        }
        AttributePoolModel[] attributePoolModelArray = moduleModel.getAttributePools();
        int n4 = 0;
        while (n4 < attributePoolModelArray.length) {
            stringBuffer.append("attPool:" + attributePoolModelArray[n4].getRole()).append("\n");
            ++n4;
        }
        objectModelArray = moduleModel.getAllObjects();
        int n5 = 0;
        while (n5 < objectModelArray.length) {
            stringBuffer.append("allElement:" + objectModelArray[n5].getLabel()).append("\n");
            ++n5;
        }
        hedgeRuleElementModelArray = moduleModel.getAllHedgeRules();
        int n6 = 0;
        while (n6 < hedgeRuleElementModelArray.length) {
            stringBuffer.append("allHedgeRule:" + hedgeRuleElementModelArray[n6].getLabel()).append("\n");
            ++n6;
        }
        attributePoolModelArray = moduleModel.getAllAttributePools();
        int n7 = 0;
        while (n7 < attributePoolModelArray.length) {
            stringBuffer.append("allAttPool:" + attributePoolModelArray[n7].getRole()).append("\n");
            ++n7;
        }
        return stringBuffer.toString();
    }

    String format(String string, Element element) {
        return this.format(string, element.toString());
    }

    String format(String string, String string2) {
        return MessageFormat.format(MainApp.getResString(string), string2);
    }

    void throwException(String string) throws MkRelaxException {
        String string2 = "";
        while (this.pathStack.size() > 0) {
            string2 = this.pathStack.pop() + ">" + string2;
        }
        String string3 = "\n [error path : " + string2 + "]";
        throw new MkRelaxException(string + string3);
    }

    public static String document2string(Document document) {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setIndenting(true);
        XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
        try {
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException? : " + iOException.getMessage());
        }
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) {
        try {
            ModuleModel moduleModel = RelaxReader.getModuleFromFile(stringArray[0]);
            System.out.println(moduleModel.getRelax());
            System.out.println(RelaxReader.getDumpModule(moduleModel));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

