/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.util.ArrayList;
import java.util.Stack;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractHedgeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ChoiceElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.EmptyElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRuleElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.MixedModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.NoneElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.SequenceElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.Visitor;

public class VisitorCenter {
    ModuleModel module;
    Visitor visitor;
    int loop = 0;
    Stack objectStack = new Stack();
    boolean traverseObject = true;
    boolean traverseHedgeRule = false;
    boolean insideOnly = false;
    ArrayList encounteredObjects = new ArrayList();

    public static Visitor traverseObjectAroundAllModules(ModuleModel moduleModel, Visitor visitor) {
        VisitorCenter.traverseObject(moduleModel, visitor);
        ModuleModel[] moduleModelArray = moduleModel.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            VisitorCenter.traverseObject(moduleModelArray[n], visitor);
            ++n;
        }
        return visitor;
    }

    public static Visitor traverseHedgeRuleAroundAllModules(ModuleModel moduleModel, Visitor visitor) {
        VisitorCenter.traverseHedgeRule(moduleModel, visitor);
        ModuleModel[] moduleModelArray = moduleModel.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            VisitorCenter.traverseHedgeRule(moduleModelArray[n], visitor);
            ++n;
        }
        return visitor;
    }

    public static Visitor traverseAllAroundModules(ModuleModel moduleModel, Visitor visitor) {
        VisitorCenter.traverseAll(moduleModel, visitor);
        ModuleModel[] moduleModelArray = moduleModel.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            VisitorCenter.traverseAll(moduleModelArray[n], visitor);
            ++n;
        }
        return visitor;
    }

    public static Visitor traverseObject(ModuleModel moduleModel, Visitor visitor) {
        VisitorCenter visitorCenter = new VisitorCenter(moduleModel, visitor);
        visitorCenter.startVisitor();
        return visitor;
    }

    public static Visitor traverseHedgeRule(ModuleModel moduleModel, Visitor visitor) {
        VisitorCenter visitorCenter = new VisitorCenter(moduleModel, visitor, false, true, false);
        visitorCenter.startVisitor();
        return visitor;
    }

    public static Visitor traverseAll(ModuleModel moduleModel, Visitor visitor) {
        VisitorCenter visitorCenter = new VisitorCenter(moduleModel, visitor, true, true, false);
        visitorCenter.startVisitor();
        return visitor;
    }

    public static Visitor traverseAllInsideObjects(ModuleModel moduleModel, Visitor visitor) {
        VisitorCenter visitorCenter = new VisitorCenter(moduleModel, visitor, true, true, true);
        visitorCenter.startVisitor();
        return visitor;
    }

    protected VisitorCenter(ModuleModel moduleModel, Visitor visitor, boolean bl, boolean bl2, boolean bl3) {
        this.loop = visitor.getAllowedNestedLoop();
        this.module = moduleModel;
        this.visitor = visitor;
        this.traverseObject = bl;
        this.traverseHedgeRule = bl2;
        this.insideOnly = bl3;
    }

    protected VisitorCenter(ModuleModel moduleModel, Visitor visitor) {
        this(moduleModel, visitor, true, false, false);
    }

    protected void startVisitor() {
        int n;
        ElementOperation[] elementOperationArray;
        this.visitor.start(this.module);
        if (this.traverseObject) {
            elementOperationArray = this.module.getRootObjects();
            n = 0;
            while (n < elementOperationArray.length) {
                MainApp.getAppContext().getMonitor().debugStackTrace("VISITOR:root>" + ((ObjectModel)elementOperationArray[n]).getLabel());
                this.root((ObjectModel)elementOperationArray[n]);
                ++n;
            }
        }
        if (this.traverseHedgeRule) {
            elementOperationArray = this.module.getHedgeRules();
            n = 0;
            while (n < elementOperationArray.length) {
                this.hedgeRuleRoot((HedgeRuleElementModel)elementOperationArray[n]);
                ++n;
            }
        }
        this.visitor.end(this.module);
    }

    protected void hedgeRuleRoot(HedgeRuleElementModel hedgeRuleElementModel) {
        this.hedgeRule(hedgeRuleElementModel);
    }

    protected void hedgeRule(HedgeRuleElementModel hedgeRuleElementModel) {
        if (hedgeRuleElementModel == null) {
            return;
        }
        if (this.insideOnly && hedgeRuleElementModel.getParentModule() != this.module) {
            return;
        }
        this.visitor.hedgeRuleEnter(hedgeRuleElementModel);
        this.objectStack.push(hedgeRuleElementModel);
        AbstractHedgeModel abstractHedgeModel = hedgeRuleElementModel.getElement();
        if (abstractHedgeModel != null) {
            if (abstractHedgeModel instanceof AbstractHedgeModel) {
                this.hedge(abstractHedgeModel);
            } else {
                throw new InternalError("No such element [" + abstractHedgeModel + "]");
            }
        }
        this.objectStack.pop();
        this.visitor.hedgeRuleExit(hedgeRuleElementModel);
    }

    protected void root(ObjectModel objectModel) {
        if (objectModel == null) {
            throw new InternalError("Root object is null!");
        }
        this.visitor.root(objectModel);
        this.object(objectModel);
    }

    protected void object(ObjectModel objectModel) {
        if (objectModel == null) {
            return;
        }
        if (this.insideOnly && objectModel.getParentModule() != this.module) {
            return;
        }
        if (this.encounteredObjects.contains(objectModel)) {
            if (this.visitor.isOnlyFirstContact()) {
                return;
            }
        } else {
            this.encounteredObjects.add(objectModel);
        }
        if (this.objectStack.contains(objectModel) && this.visitor.getAllowedNestedLoop() <= 0) {
            return;
        }
        int n = this.countObjectNum(objectModel);
        if (this.visitor.getAllowedNestedLoop() > 0 && n >= this.visitor.getAllowedNestedLoop()) {
            return;
        }
        this.objectStack.push(objectModel);
        this.visitor.objectEnter(objectModel, n);
        ElementModel elementModel = objectModel.getElement();
        if (elementModel != null) {
            if (elementModel instanceof MixedModel) {
                this.mixed((MixedModel)elementModel);
            } else if (elementModel instanceof AbstractHedgeModel) {
                this.hedge((AbstractHedgeModel)elementModel);
            } else {
                throw new InternalError("No such element [" + elementModel + "]");
            }
        }
        this.objectStack.pop();
        this.visitor.objectExit(objectModel);
    }

    int countObjectNum(ObjectModel objectModel) {
        if (this.objectStack.contains(objectModel)) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.objectStack.size()) {
                if (this.objectStack.get(n2) == objectModel) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }
        return 0;
    }

    protected void hedge(AbstractHedgeModel abstractHedgeModel) {
        if (abstractHedgeModel == null) {
            return;
        }
        if (abstractHedgeModel instanceof NoneElementModel) {
            this.none((NoneElementModel)abstractHedgeModel);
        } else if (abstractHedgeModel instanceof EmptyElementModel) {
            this.empty((EmptyElementModel)abstractHedgeModel);
        } else if (abstractHedgeModel instanceof ChoiceElementModel) {
            this.choice((ChoiceElementModel)abstractHedgeModel);
        } else if (abstractHedgeModel instanceof SequenceElementModel) {
            this.sequence((SequenceElementModel)abstractHedgeModel);
        } else if (abstractHedgeModel instanceof HedgeRefElementModel) {
            this.hedgeRef((HedgeRefElementModel)abstractHedgeModel);
        } else if (abstractHedgeModel instanceof RefElementModel) {
            this.ref((RefElementModel)abstractHedgeModel);
        } else {
            throw new InternalError("No such element [" + abstractHedgeModel + "]");
        }
    }

    protected void mixed(MixedModel mixedModel) {
        this.visitor.mixedEnter(mixedModel);
        this.hedge(mixedModel.getElement());
        this.visitor.mixedExit(mixedModel);
    }

    protected void none(NoneElementModel noneElementModel) {
        this.visitor.none(noneElementModel);
    }

    protected void empty(EmptyElementModel emptyElementModel) {
        this.visitor.empty(emptyElementModel);
    }

    protected void choice(ChoiceElementModel choiceElementModel) {
        this.visitor.choiceEnter(choiceElementModel);
        AbstractHedgeModel[] abstractHedgeModelArray = choiceElementModel.getElements();
        int n = 0;
        while (n < abstractHedgeModelArray.length) {
            this.hedge(abstractHedgeModelArray[n]);
            ++n;
        }
        this.visitor.choiceExit(choiceElementModel);
    }

    protected void sequence(SequenceElementModel sequenceElementModel) {
        this.visitor.sequenceEnter(sequenceElementModel);
        AbstractHedgeModel[] abstractHedgeModelArray = sequenceElementModel.getElements();
        int n = 0;
        while (n < abstractHedgeModelArray.length) {
            this.hedge(abstractHedgeModelArray[n]);
            ++n;
        }
        this.visitor.sequenceExit(sequenceElementModel);
    }

    protected void hedgeRef(HedgeRefElementModel hedgeRefElementModel) {
        this.visitor.hedgeRef(hedgeRefElementModel);
    }

    protected void ref(RefElementModel refElementModel) {
        this.visitor.ref(refElementModel);
        this.object(refElementModel.getAt());
    }
}

