/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.datatype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.ccs2.tool.mkrelax.datatype.Entries;
import jp.gr.java_conf.ccs2.tool.mkrelax.datatype.RStack;
import jp.gr.java_conf.ccs2.tool.mkrelax.datatype.UJAXP;
import jp.gr.java_conf.ccs2.tool.mkrelax.datatype.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Datatypes
implements Serializable {
    private String defaultType_;
    private Entries entries_;

    public Datatypes() {
    }

    public Datatypes(RStack rStack) {
        this.setup(rStack);
    }

    public Datatypes(Document document) {
        this.setup(document.getDocumentElement());
    }

    public Datatypes(Element element) {
        this.setup(element);
    }

    public Datatypes(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Datatypes(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public Datatypes(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public Datatypes(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public Datatypes(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public Datatypes(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.setup(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.defaultType_ = URelaxer.getElementPropertyAsString(rStack.popElement());
        this.setEntries(new Entries(rStack));
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("datatypes");
        URelaxer.setElementPropertyByString(element, "defaultType", this.defaultType_);
        this.entries_.makeElement(element);
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 1));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 1));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 1));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 1));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 1));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final String getDefaultType() {
        return this.defaultType_;
    }

    public final void setDefaultType(String string) {
        this.defaultType_ = string;
    }

    public final Entries getEntries() {
        return this.entries_;
    }

    public final void setEntries(Entries entries) {
        this.entries_ = entries;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<datatypes");
        stringBuffer.append(">");
        stringBuffer.append("<defaultType>");
        stringBuffer.append(URelaxer.escapeCharData(this.getDefaultType()));
        stringBuffer.append("</defaultType>");
        this.entries_.makeTextElement(stringBuffer);
        stringBuffer.append("</datatypes>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<datatypes");
        printWriter.print(">");
        printWriter.print("<defaultType>");
        printWriter.print(URelaxer.escapeCharData(this.getDefaultType()));
        printWriter.print("</defaultType>");
        this.entries_.makeTextElement(printWriter);
        printWriter.print("</datatypes>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "datatypes")) {
            return false;
        }
        RStack rStack = new RStack(element);
        Element element2 = rStack.popElement();
        if (element2 == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(element2, "defaultType")) {
            return false;
        }
        if (!Entries.isMatchHungry(rStack)) {
            return false;
        }
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return Datatypes.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (Datatypes.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

