/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.ChoiceElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.EmptyElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRuleElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MixedModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.NoneElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.SequenceElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.Visitor;
import jp.gr.java_conf.ccs2.tool.mkrelax.VisitorClass;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNChoice;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNElement;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNEmpty;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNHedgeRef;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNHedgeRule;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNMixed;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNModule;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNNone;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNObject;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNSequence;

public abstract class AbstractObjectTreeModel
extends DefaultTreeModel {
    ModuleModel mainModule;
    TNElement mainRoot;
    MessageListener messageListener;

    public AbstractObjectTreeModel(ModuleModel moduleModel, MessageListener messageListener) {
        super(new TNModule(moduleModel, messageListener));
        this.mainModule = moduleModel;
        this.messageListener = messageListener;
        this.setupRoots();
    }

    protected abstract TNElement createRootNode(ModuleModel var1);

    protected abstract TNElement createIncludedNode(ModuleModel var1, TNElement var2);

    private void setupRoots() {
        TNElement tNElement = this.createRootNode(this.mainModule);
        this.setupRootNode(this.mainModule, tNElement);
        this.setRoot(tNElement);
        ModuleModel[] moduleModelArray = this.mainModule.getIncludeModules();
        int n = 0;
        while (n < moduleModelArray.length) {
            TNElement tNElement2 = this.createIncludedNode(moduleModelArray[n], tNElement);
            this.setupRootNode(moduleModelArray[n], tNElement2);
            tNElement.addChild(tNElement2);
            ++n;
        }
    }

    protected abstract void traverse(ModuleModel var1, Visitor var2);

    protected abstract void traverseAll(ModuleModel var1, Visitor var2);

    private void setupRootNode(ModuleModel moduleModel, TNElement tNElement) {
        AVisitor aVisitor = new AVisitor(tNElement);
        if (moduleModel == this.mainModule) {
            this.traverse(moduleModel, aVisitor);
        } else {
            this.traverseAll(moduleModel, aVisitor);
        }
    }

    public TNElement getMainRootNode() {
        return this.mainRoot;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    class AVisitor
    extends VisitorClass {
        TNElement curRoot;
        Stack nodeStack = new Stack();
        RefElementModel ref;
        List currentChildren = new ArrayList();
        Stack childrenStack = new Stack();

        AVisitor(TNElement tNElement) {
            this.curRoot = tNElement;
        }

        protected TNElement getCurrentRoot() {
            return this.curRoot;
        }

        public int getAllowedNestedLoop() {
            return 1;
        }

        public void start(ModuleModel moduleModel) {
            this.nodeStack.push(this.getCurrentRoot());
        }

        public void end(ModuleModel moduleModel) {
            this.nodeStack.pop();
            this.getCurrentRoot().setElements(this.children());
        }

        public void root(ObjectModel objectModel) {
        }

        void pushChildren() {
            this.childrenStack.push(this.currentChildren);
            this.currentChildren = new ArrayList();
        }

        void popChildren() {
            this.currentChildren = (List)this.childrenStack.pop();
        }

        TNElement curParent() {
            return (TNElement)this.nodeStack.peek();
        }

        TreeNode[] children() {
            if (this.currentChildren == null) {
                return new TreeNode[0];
            }
            TreeNode[] treeNodeArray = new TreeNode[this.currentChildren.size()];
            return this.currentChildren.toArray(treeNodeArray);
        }

        void begin(TNElement tNElement) {
            this.nodeStack.push(tNElement);
            this.pushChildren();
        }

        void end() {
            TNElement tNElement = (TNElement)this.nodeStack.pop();
            tNElement.setElements(this.children());
            this.popChildren();
            this.currentChildren.add(tNElement);
        }

        public void hedgeRuleEnter(HedgeRuleElementModel hedgeRuleElementModel) {
            this.begin(new TNHedgeRule((TreeNode)this.curParent(), AbstractObjectTreeModel.this.messageListener, hedgeRuleElementModel));
        }

        public void hedgeRuleExit(HedgeRuleElementModel hedgeRuleElementModel) {
            this.end();
        }

        public void objectEnter(ObjectModel objectModel, int n) {
            TNObject tNObject = null;
            tNObject = n == this.getAllowedNestedLoop() ? new TNObject(this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), objectModel, true) : new TNObject((TreeNode)this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), objectModel);
            if (this.ref != null) {
                tNObject.setRef(this.ref);
            }
            this.ref = null;
            this.begin(tNObject);
        }

        public void objectExit(ObjectModel objectModel) {
            TNObject tNObject = (TNObject)this.nodeStack.pop();
            if (!tNObject.isShadow()) {
                tNObject.setElements(this.children());
            }
            this.popChildren();
            this.currentChildren.add(tNObject);
        }

        public void mixedEnter(MixedModel mixedModel) {
            this.begin(new TNMixed((TreeNode)this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), mixedModel));
        }

        public void mixedExit(MixedModel mixedModel) {
            this.end();
        }

        public void none(NoneElementModel noneElementModel) {
            TNNone tNNone = new TNNone((TreeNode)this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), noneElementModel);
            this.currentChildren.add(tNNone);
        }

        public void empty(EmptyElementModel emptyElementModel) {
            TNEmpty tNEmpty = new TNEmpty((TreeNode)this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), emptyElementModel);
            this.currentChildren.add(tNEmpty);
        }

        public void choiceEnter(ChoiceElementModel choiceElementModel) {
            this.begin(new TNChoice((TreeNode)this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), choiceElementModel));
        }

        public void choiceExit(ChoiceElementModel choiceElementModel) {
            this.end();
        }

        public void sequenceEnter(SequenceElementModel sequenceElementModel) {
            this.begin(new TNSequence((TreeNode)this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), sequenceElementModel));
        }

        public void sequenceExit(SequenceElementModel sequenceElementModel) {
            this.end();
        }

        public void hedgeRef(HedgeRefElementModel hedgeRefElementModel) {
            TNHedgeRef tNHedgeRef = new TNHedgeRef((TreeNode)this.curParent(), AbstractObjectTreeModel.this.getMessageListener(), hedgeRefElementModel);
            this.currentChildren.add(tNHedgeRef);
        }

        public void ref(RefElementModel refElementModel) {
            this.ref = refElementModel;
        }
    }
}

