/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.AboutDialog;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.GuiUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.ModulePanel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNAttribute;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNCommon;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNElement;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNHedgeRuleRoot;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNModule;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.RelaxerDialog;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class MainFrame
extends JFrame {
    ModulePanel modulePanel;
    RelaxerDialog relaxerDialog;
    JMenuItem copyMenuItem;
    JMenuItem cutMenuItem;
    JMenuItem pasteMenuItem;
    JMenuItem undoMenuItem;
    JMenuItem removeThisMenuItem;
    JMenuItem removeBranchMenuItem;
    JMenuItem relaxerMenuItem;
    ActionListener newAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.newModule();
        }
    };
    ActionListener exitAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.exitModule();
        }
    };
    ActionListener saveAsAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.saveAsModule();
        }
    };
    ActionListener loadAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.loadModule();
        }
    };
    ActionListener saveAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.saveModule();
        }
    };
    ActionListener execRelaxerAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.execRelaxer();
        }
    };
    ActionListener aboutAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.aboutDialog();
        }
    };
    ActionListener undoAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.undoModule();
        }
    };
    ActionListener copyAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.copyElement();
        }
    };
    ActionListener cutAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.cutElement();
        }
    };
    ActionListener pasteAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.pasteElement();
        }
    };
    ActionListener removeThisAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.removeThisElement();
        }
    };
    ActionListener removeBranchAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.removeBranchElement();
        }
    };
    TNCommon copiedNode;
    MessageListener compListener = new MessageListener(){

        void disableAllMenu() {
            MainFrame.this.cutMenuItem.setEnabled(false);
            MainFrame.this.copyMenuItem.setEnabled(false);
            MainFrame.this.pasteMenuItem.setEnabled(false);
            MainFrame.this.removeThisMenuItem.setEnabled(false);
            MainFrame.this.removeBranchMenuItem.setEnabled(false);
        }

        void moduleSelected() {
            MainFrame.this.pasteMenuItem.setEnabled(false);
            MainFrame.this.removeThisMenuItem.setEnabled(false);
            MainFrame.this.cutMenuItem.setEnabled(false);
            MainFrame.this.copyMenuItem.setEnabled(false);
            MainFrame.this.removeBranchMenuItem.setEnabled(false);
        }

        void elementSelected(TNElement tNElement) {
            ElementOperation elementOperation = tNElement.getElementOperation();
            MainFrame.this.pasteMenuItem.setEnabled(false);
            MainFrame.this.removeThisMenuItem.setEnabled(TNElement.removeConnectCheck(tNElement.getElParent().getElementOperation(), elementOperation));
            MainFrame.this.cutMenuItem.setEnabled(true);
            MainFrame.this.copyMenuItem.setEnabled(true);
            MainFrame.this.removeBranchMenuItem.setEnabled(true);
            if (MainFrame.this.copiedNode != null && MainFrame.this.copiedNode instanceof TNElement) {
                ElementOperation elementOperation2 = ((TNElement)MainFrame.this.copiedNode).getElementOperation();
                if (elementOperation.canAddElement() && elementOperation.acceptOpElement(elementOperation2)) {
                    MainFrame.this.pasteMenuItem.setEnabled(true);
                }
            } else if (MainFrame.this.copiedNode != null && MainFrame.this.copiedNode instanceof TNAttribute && tNElement.getObject() instanceof AttributeOperation) {
                MainFrame.this.pasteMenuItem.setEnabled(true);
            }
        }

        void attributeSelected() {
            MainFrame.this.cutMenuItem.setEnabled(true);
            MainFrame.this.copyMenuItem.setEnabled(true);
            MainFrame.this.pasteMenuItem.setEnabled(false);
            MainFrame.this.removeThisMenuItem.setEnabled(false);
            MainFrame.this.removeBranchMenuItem.setEnabled(true);
        }

        public void message(String string, int n, Object object) {
            MainFrame.this.undoMenuItem.setEnabled(MainFrame.this.modulePanel.canUndo());
            if (object == null) {
                this.disableAllMenu();
                return;
            }
            if (object instanceof TNElement) {
                TNElement tNElement = (TNElement)object;
                if (object instanceof TNModule || object instanceof TNHedgeRuleRoot) {
                    this.moduleSelected();
                } else {
                    this.elementSelected(tNElement);
                }
            } else if (object instanceof TNAttribute) {
                this.attributeSelected();
            }
        }
    };

    public MainFrame(ModulePanel modulePanel) {
        super(MainFrame.getRes("frameTitle"));
        this.setModulePanel(modulePanel);
        this.initGui();
    }

    private static String getRes(String string) {
        return MainApp.getResString(string);
    }

    public void setModulePanel(ModulePanel modulePanel) {
        this.modulePanel = modulePanel;
        this.modulePanel.setCompListener(this.compListener);
    }

    public void initGui() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.modulePanel, "Center");
        this.initMenu();
        this.initToolbar();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.exitModule();
            }
        });
    }

    void initMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(MainFrame.getRes("File") + "(F)");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = GuiUtil.getMenuItem("NewModule", "NewModule", this.newAction, MainFrame.getRes("IconFileNew"), Boolean.TRUE);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = GuiUtil.getMenuItem("OpenModule", "OpenModule", this.loadAction, MainFrame.getRes("IconFileOpen"), Boolean.TRUE);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem);
        jMenuItem = GuiUtil.getMenuItem("SaveModule", "SaveModule", this.saveAction, MainFrame.getRes("IconFileSave"), Boolean.TRUE);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(jMenuItem);
        jMenu.add(GuiUtil.getMenuItem("SaveAsModule", "SaveAsModule", this.saveAsAction, MainFrame.getRes("IconFileSaveAs"), Boolean.TRUE));
        jMenu.addSeparator();
        jMenuItem = GuiUtil.getMenuItem("ExecRelaxer", "ExecRelaxer", this.execRelaxerAction, MainFrame.getRes("IconExecRelaxer"), Boolean.TRUE);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(GuiUtil.getMenuItem("ExitModule", "ExitModule", this.exitAction, MainFrame.getRes("IconFileExit"), Boolean.TRUE));
        jMenuBar.add(jMenu);
        jMenu = new JMenu(MainFrame.getRes("Edit") + "(E)");
        jMenu.setMnemonic(69);
        this.undoMenuItem = GuiUtil.getMenuItem("Undo", "Undo", this.undoAction, MainFrame.getRes("IconEditUndo"), Boolean.FALSE);
        jMenu.add(this.undoMenuItem);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        jMenu.addSeparator();
        this.copyMenuItem = GuiUtil.getMenuItem("Copy", "Copy", this.copyAction, MainFrame.getRes("IconEditCopy"), Boolean.FALSE);
        jMenu.add(this.copyMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.cutMenuItem = GuiUtil.getMenuItem("Cut", "Cut", this.cutAction, MainFrame.getRes("IconEditCut"), Boolean.FALSE);
        jMenu.add(this.cutMenuItem);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.pasteMenuItem = GuiUtil.getMenuItem("Paste", "Paste", this.pasteAction, MainFrame.getRes("IconEditPaste"), Boolean.FALSE);
        jMenu.add(this.pasteMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenu.addSeparator();
        this.removeThisMenuItem = GuiUtil.getMenuItem("RemoveConnect", "RemoveT", this.removeThisAction, MainFrame.getRes("IconEditRemoveThis"), Boolean.FALSE);
        jMenu.add(this.removeThisMenuItem);
        this.removeThisMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        this.removeBranchMenuItem = GuiUtil.getMenuItem("RemoveBranch", "RemoveB", this.removeBranchAction, MainFrame.getRes("IconEditRemoveBranch"), Boolean.FALSE);
        jMenu.add(this.removeBranchMenuItem);
        this.removeBranchMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jMenuBar.add(jMenu);
        jMenu = new JMenu(MainFrame.getRes("Help") + "(H)");
        jMenu.setMnemonic(72);
        jMenu.add(GuiUtil.getMenuItem("About", "About", this.aboutAction, MainFrame.getRes("IconHelpAbout"), Boolean.TRUE));
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jMenu);
    }

    void initToolbar() {
    }

    void undoModule() {
        this.modulePanel.undo();
    }

    void removeThisElement() {
        TNCommon tNCommon = this.modulePanel.getSelectedNode();
        if (!(tNCommon instanceof TNElement)) {
            throw new InternalError("Forbidden opration.");
        }
        ((TNElement)tNCommon).removeConnect(this, false);
    }

    void removeBranchElement() {
        this.modulePanel.getSelectedNode().removeBranch(this, false);
    }

    void copyElement() {
        this.copiedNode = this.modulePanel.getSelectedNode();
    }

    void cutElement() {
        this.copiedNode = this.modulePanel.getSelectedNode();
        this.copiedNode.removeBranch(this, true);
    }

    void pasteElement() {
        if (this.copiedNode == null) {
            throw new InternalError("Copied buffer is null.");
        }
        if (this.modulePanel.getSelectedNode() == null) {
            throw new InternalError("Selected node is null.");
        }
        if (this.copiedNode instanceof TNElement && this.modulePanel.getSelectedNode() instanceof TNElement) {
            this.pasteElementIntoElement();
        } else if (this.copiedNode instanceof TNAttribute && this.modulePanel.getSelectedNode() instanceof TNElement) {
            this.pasteAttributeIntoElement();
        }
    }

    private void pasteElementIntoElement() {
        ElementOperation elementOperation = ((TNElement)this.copiedNode).getElementOperation();
        ElementOperation elementOperation2 = ((TNElement)this.modulePanel.getSelectedNode()).getElementOperation();
        if (!elementOperation2.canAddElement() || !elementOperation2.acceptOpElement(elementOperation)) {
            throw new InternalError("Forbidden operation.");
        }
        elementOperation2.addOpElements(ElementUtil.toArray(elementOperation.getOpCopy()));
        this.modulePanel.getSelectedNode().sendTreeChangedMessage();
    }

    private void pasteAttributeIntoElement() {
        ObjectModel objectModel = (ObjectModel)this.modulePanel.getSelectedNode().getObject();
        AttributeModel attributeModel = ((TNAttribute)this.copiedNode).getAttribute();
        objectModel.addAttribute(attributeModel.getCopy());
        this.modulePanel.getSelectedNode().sendTreeChangedMessage();
    }

    void execRelaxer() {
        if (this.relaxerDialog == null || !this.relaxerDialog.isShown()) {
            if (StringUtil.isNull(this.modulePanel.getModuleFilename())) {
                this.saveAsModule();
                if (StringUtil.isNull(this.modulePanel.getModuleFilename())) {
                    return;
                }
            }
            this.relaxerDialog = new RelaxerDialog(this.modulePanel.getModuleFilename());
            this.relaxerDialog.show();
        } else {
            this.relaxerDialog.show();
        }
    }

    void newModule() {
        this.modulePanel.newModule();
    }

    void saveAsModule() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(MainApp.getRelaxFileFilter());
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.getPath();
            if (file.getName().indexOf(".") == -1) {
                string = string + ".rlx";
            }
            this.modulePanel.saveModule(string);
        }
    }

    void saveModule() {
        if (StringUtil.isNull(this.modulePanel.getModuleFilename())) {
            this.saveAsModule();
        } else {
            this.modulePanel.saveModule(this.modulePanel.getModuleFilename());
        }
    }

    void loadModule() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(MainApp.getRelaxFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.modulePanel.loadModule(file.getPath());
            if (this.relaxerDialog != null) {
                this.relaxerDialog.dispose();
            }
        }
    }

    void exitModule() {
        if (this.modulePanel.isModuleModified()) {
            Object[] objectArray = new String[]{this.modulePanel.getModuleName()};
            String string = MessageFormat.format(MainFrame.getRes("OnExitDoYouSaveModule{0}?"), objectArray);
            int n = JOptionPane.showConfirmDialog(this, string, MainFrame.getRes("ExitConfirm"), 0);
            if (n == 0) {
                this.saveModule();
            }
        }
        System.exit(0);
    }

    void aboutDialog() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.show();
    }
}

