/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.MkRelaxException;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RelaxReader;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.AttributePoolTreeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.HedgeRuleTreeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.ObjectTreeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.ObjectTreeRenderer;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNCommon;

public class ModulePanel
extends JPanel {
    private ModuleModel module;
    private JTabbedPane tab;
    private Stack undoStack = new Stack();
    private boolean enableUndo = true;
    private int undoSize = 4;
    private ObjectTreeModel objectTreeModel;
    private JTree objectTree;
    private JPanel propertyPanel;
    private AttributePoolTreeModel poolTreeModel;
    private JTree poolTree;
    private JPanel poolPropertyPanel;
    private HedgeRuleTreeModel hedgeTreeModel;
    private JTree hedgeTree;
    private JPanel hedgePropertyPanel;
    private JTextArea sourceText = new JTextArea();
    private MessageListener compListener;
    TreeSelectionListener treeValueChangedListener = new TreeSelectionListener(){

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (ModulePanel.this.compListener != null) {
                ModulePanel.this.compListener.message("", 0, ModulePanel.this.getSelectedNode());
            }
            ModulePanel.this.showObjectProperty();
        }
    };
    MouseAdapter treeMouseAdapter = new MouseAdapter(){
        boolean showed = false;

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.isControlDown()) {
                this.execPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.isPopupTrigger() || mouseEvent.isControlDown()) && !this.showed) {
                this.execPopup(mouseEvent);
            }
            this.showed = false;
        }

        void execPopup(MouseEvent mouseEvent) {
            TreePath treePath = ModulePanel.this.getCurrentTree().getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            TNCommon tNCommon = ModulePanel.this.translatePath(treePath);
            if (tNCommon == null) {
                return;
            }
            ModulePanel.this.getCurrentTree().setSelectionPath(treePath);
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            ModulePanel.this.showPopupMenu(mouseEvent.getComponent(), n, n2, tNCommon);
        }
    };
    KeyAdapter keyAdapterOnPropPanel = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 123: {
                    ModulePanel.this.getCurrentTree().requestFocus();
                    return;
                }
            }
            ModulePanel.this.processTabKey(keyEvent.getKeyCode());
        }
    };
    KeyAdapter keyAdapterOnSource = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            ModulePanel.this.processTabKey(keyEvent.getKeyCode());
        }
    };
    private KeyAdapter keyAdapterOnTree = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 123: {
                    ModulePanel.this.traverseTab(ModulePanel.this.getCurrentPanel());
                    return;
                }
                case 27: {
                    ModulePanel.this.showPopupMenu();
                    return;
                }
            }
            ModulePanel.this.processTabKey(keyEvent.getKeyCode());
        }
    };
    private MessageListener messageListener = new MessageListener(){

        public void message(String string, int n, Object object) {
            switch (n) {
                case 4: {
                    if (object == null) {
                        object = ModulePanel.this.getCurrentTreeModel().getRoot();
                    }
                    ((DefaultTreeModel)ModulePanel.this.getCurrentTreeModel()).nodeChanged((TNCommon)object);
                    ModulePanel.this.prepareUndo();
                    return;
                }
                case 2: {
                    ModulePanel.this.reinitTreeModel();
                    return;
                }
                case 1: {
                    ModulePanel.this.reloadModule((List)object);
                    return;
                }
            }
            throw new InternalError("No such message. [" + n + "]");
        }
    };

    public ModulePanel(ModuleModel moduleModel) {
        super(new BorderLayout());
        this.enableUndo = !MainApp.getAppContext().getConfig().getOption("noundo");
        this.undoSize = MainApp.getAppContext().getConfig().getOptionInteger("undoNum") + 1;
        if (this.undoSize < 2) {
            this.enableUndo = false;
            this.undoSize = 0;
        }
        this.module = moduleModel;
        this.initGui();
    }

    public String getModuleName() {
        return this.module.getModuleName();
    }

    public String getModuleFilename() {
        return this.module.getModuleFilename();
    }

    public boolean isModuleModified() {
        return this.module.isModified();
    }

    public void setCompListener(MessageListener messageListener) {
        this.compListener = messageListener;
    }

    public void newModule() {
        this.module = ModuleModel.createNewModule();
        this.undoStack.clear();
        this.reinitGui();
    }

    public void saveModule(String string) {
        try {
            this.module.setModuleFilename(string);
            ModuleModel.saveModuleWithRelax(this.module, string);
            this.reinitTreeModel();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), MainApp.getResString("ErrorDialog"), 0);
        }
    }

    public void loadModule(String string) {
        try {
            this.module = ModuleModel.loadModuleFromRelax(string);
            this.undoStack.clear();
            this.reinitGui();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), MainApp.getResString("ErrorDialog"), 0);
        }
    }

    protected void reloadModule(List list) {
        try {
            this.module = RelaxReader.getModuleWithReloading(this.module, list);
            this.reinitGui();
        }
        catch (MkRelaxException mkRelaxException) {
            JOptionPane.showMessageDialog(this, mkRelaxException.getMessage(), MainApp.getResString("ErrorDialog"), 0);
        }
    }

    public boolean canUndo() {
        return this.undoStack.size() > 1;
    }

    protected void prepareUndo() {
        if (!this.enableUndo) {
            return;
        }
        String string = this.module.getRelax();
        if (this.undoStack.size() > 0 && string.equals((String)this.undoStack.peek())) {
            return;
        }
        if (!this.undoStack.isEmpty()) {
            this.module.modified();
        }
        this.undoStack.push(string);
        while (this.undoStack.size() > this.undoSize) {
            this.undoStack.remove(0);
        }
        MainApp.getAppContext().getMonitor().debug("UNDO:" + this.undoStack.size());
    }

    public void undo() {
        if (this.undoStack.size() > 1) {
            try {
                this.undoStack.pop();
                this.module = ModuleModel.relax2module((String)this.undoStack.pop(), this.module.getModuleFilename());
            }
            catch (MkRelaxException mkRelaxException) {
                JOptionPane.showMessageDialog(this, mkRelaxException.getMessage(), MainApp.getResString("ErrorDialog"), 0);
            }
            this.reinitTreeModel();
        }
    }

    private void initGui() {
        this.prepareUndo();
        this.tab = new JTabbedPane();
        this.tab.add(MainApp.getResString("objectPane"), this.initObjectPane());
        this.tab.add(MainApp.getResString("attributePoolPane"), this.initPoolPane());
        this.tab.add(MainApp.getResString("hedgeRulePane"), this.initHedgeRulePane());
        this.tab.add(MainApp.getResString("sourcePane"), this.initSourcePane());
        this.tab.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ModulePanel.this.tab.getSelectedIndex() == 3) {
                    ModulePanel.this.updateSourceText();
                }
            }
        });
        this.add((Component)this.tab, "Center");
        this.getCurrentTree().setSelectionRow(0);
        this.getCurrentTree().requestFocus();
    }

    JComponent initObjectPane() {
        this.objectTree = new JTree();
        this.initObjectTreeModel();
        return this.initTree(this.objectTree, new ObjectTreeRenderer(), this.initObjectPropertyPane());
    }

    Component initPoolPane() {
        this.poolTree = new JTree();
        this.initPoolTreeModel();
        return this.initTree(this.poolTree, new ObjectTreeRenderer(), this.initPoolPropertyPane());
    }

    Component initHedgeRulePane() {
        this.hedgeTree = new JTree();
        this.initHedgeTreeModel();
        return this.initTree(this.hedgeTree, new ObjectTreeRenderer(), this.initHedgePropertyPane());
    }

    JComponent initTree(JTree jTree, TreeCellRenderer treeCellRenderer, JComponent jComponent) {
        jTree.setCellRenderer(treeCellRenderer);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        jTree.addTreeSelectionListener(this.treeValueChangedListener);
        jTree.addMouseListener(this.treeMouseAdapter);
        jTree.addKeyListener(this.keyAdapterOnTree);
        this.expandAllTrees(jTree);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        Dimension dimension = new Dimension(320, 400);
        jScrollPane.setPreferredSize(dimension);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(jComponent);
        jSplitPane.setContinuousLayout(false);
        return jSplitPane;
    }

    void expandAllTrees(JTree jTree) {
        if (jTree != null) {
            TreePath treePath;
            int n = 0;
            while ((treePath = jTree.getPathForRow(n)) != null) {
                jTree.expandPath(treePath);
                ++n;
            }
        }
    }

    void reinitGui() {
        this.reinitTreeModel();
    }

    void reinitTreeModel() {
        this.prepareUndo();
        int[] nArray = this.getCurrentTree().getSelectionRows();
        int n = 0;
        if (nArray != null && nArray.length != 0) {
            n = nArray[0];
        }
        this.initObjectTreeModel();
        this.initPoolTreeModel();
        this.initHedgeTreeModel();
        this.expandAllTrees(this.objectTree);
        this.expandAllTrees(this.poolTree);
        this.expandAllTrees(this.hedgeTree);
        this.getCurrentTree().requestFocus();
        this.getCurrentTree().setSelectionRow(n);
    }

    void initObjectTreeModel() {
        this.objectTreeModel = new ObjectTreeModel(this.module, this.messageListener);
        this.objectTree.setModel(this.objectTreeModel);
    }

    void initPoolTreeModel() {
        this.poolTreeModel = new AttributePoolTreeModel(this.module, this.messageListener);
        this.poolTree.setModel(this.poolTreeModel);
    }

    void initHedgeTreeModel() {
        this.hedgeTreeModel = new HedgeRuleTreeModel(this.module, this.messageListener);
        this.hedgeTree.setModel(this.hedgeTreeModel);
    }

    JComponent initObjectPropertyPane() {
        this.propertyPanel = new JPanel();
        return this.initGeneralPropertyPane("propertyPanel", this.propertyPanel);
    }

    JComponent initPoolPropertyPane() {
        this.poolPropertyPanel = new JPanel();
        return this.initGeneralPropertyPane("propertyPanel", this.poolPropertyPanel);
    }

    JComponent initHedgePropertyPane() {
        this.hedgePropertyPanel = new JPanel();
        return this.initGeneralPropertyPane("propertyPanel", this.hedgePropertyPanel);
    }

    JComponent initGeneralPropertyPane(String string, JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(MainApp.getResString(string)));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(280, 400));
        return jScrollPane;
    }

    Component initSourcePane() {
        this.sourceText.setEditable(false);
        this.sourceText.setLineWrap(true);
        this.sourceText.addKeyListener(this.keyAdapterOnSource);
        return new JScrollPane(this.sourceText);
    }

    void updateSourceText() {
        this.sourceText.setText(ModuleModel.module2relax(this.module));
    }

    public TNCommon getSelectedNode() {
        TreePath treePath = this.getCurrentTree().getSelectionPath();
        return this.translatePath(treePath);
    }

    public void showPopupMenu() {
        TNCommon tNCommon = this.getSelectedNode();
        if (tNCommon == null) {
            return;
        }
        Rectangle rectangle = this.getCurrentTree().getPathBounds(this.getCurrentTree().getSelectionPath());
        if (rectangle == null) {
            return;
        }
        this.showPopupMenu(this.getCurrentTree(), rectangle.x + rectangle.width, rectangle.y + rectangle.height, tNCommon);
    }

    public void showPopupMenu(Component component, int n, int n2, TNCommon tNCommon) {
        JPopupMenu jPopupMenu = tNCommon.getPopupMenu();
        if (jPopupMenu == null) {
            return;
        }
        int n3 = n2;
        Point point = component.getLocation();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        MainApp.getAppContext().getMonitor().debug("SCREEN: ps=" + point);
        MainApp.getAppContext().getMonitor().debug("SCREEN: sc=" + dimension);
        if (dimension.height / 2 < point.y) {
            n3 = n2 - jPopupMenu.getSize().height;
        }
        jPopupMenu.show(component, n, n3);
        jPopupMenu.requestFocus();
        jPopupMenu.setNextFocusableComponent(this.getCurrentTree());
    }

    JTree getCurrentTree() {
        switch (this.tab.getSelectedIndex()) {
            case 1: {
                return this.poolTree;
            }
            case 2: {
                return this.hedgeTree;
            }
        }
        return this.objectTree;
    }

    JPanel getCurrentPanel() {
        switch (this.tab.getSelectedIndex()) {
            case 1: {
                return this.poolPropertyPanel;
            }
            case 2: {
                return this.hedgePropertyPanel;
            }
        }
        return this.propertyPanel;
    }

    TreeModel getCurrentTreeModel() {
        return this.getCurrentTree().getModel();
    }

    TNCommon translatePath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null) {
            return null;
        }
        if (object instanceof TNCommon) {
            this.getCurrentPanel().removeAll();
            TNCommon tNCommon = (TNCommon)object;
            return tNCommon;
        }
        return null;
    }

    void showObjectProperty() {
        TNCommon tNCommon = this.getSelectedNode();
        if (tNCommon == null) {
            this.getCurrentPanel().revalidate();
            this.getCurrentPanel().repaint();
            return;
        }
        this.getCurrentPanel().removeAll();
        JPanel jPanel = tNCommon.getPropertyPaneGen(this.keyAdapterOnPropPanel);
        jPanel.setOpaque(true);
        this.getCurrentPanel().add((Component)jPanel, "Center");
        this.getCurrentPanel().revalidate();
        this.getCurrentPanel().repaint();
    }

    void disablePanel(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] != null) {
                if (componentArray[n] instanceof Container) {
                    this.disablePanel((Container)componentArray[n]);
                }
                if (componentArray[n] instanceof JTextComponent || componentArray[n] instanceof AbstractButton) {
                    componentArray[n].setEnabled(false);
                }
            }
            ++n;
        }
    }

    void forceKeyEvent(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] != null) {
                if (componentArray[n] instanceof Container) {
                    this.forceKeyEvent((Container)componentArray[n]);
                }
                if (componentArray[n] instanceof JTextComponent || componentArray[n] instanceof AbstractButton) {
                    componentArray[n].removeKeyListener(this.keyAdapterOnPropPanel);
                    componentArray[n].addKeyListener(this.keyAdapterOnPropPanel);
                }
            }
            ++n;
        }
    }

    void processTabKey(int n) {
        switch (n) {
            case 112: {
                this.tab.setSelectedIndex(0);
                this.objectTree.requestFocus();
                break;
            }
            case 113: {
                this.tab.setSelectedIndex(1);
                this.poolTree.requestFocus();
                break;
            }
            case 114: {
                this.tab.setSelectedIndex(2);
                this.hedgeTree.requestFocus();
                break;
            }
            case 115: {
                this.tab.setSelectedIndex(3);
                this.sourceText.requestFocus();
                break;
            }
        }
    }

    void traverseTab(JComponent jComponent) {
        if (!jComponent.isFocusTraversable()) {
            FocusManager.getCurrentManager().focusNextComponent(jComponent);
        }
    }
}

