/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNAttributeRef;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNCommon;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNConAttribute;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNHedgeRef;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNMixed;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNMultiElement;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNObject;

class ObjectTreeRenderer
extends DefaultTreeCellRenderer {
    Color ctrlElementColor = Color.blue;
    Color elementColor = Color.black;
    Color attributeColor = Color.green.darker();
    Color exportColor = Color.pink.darker();
    Color ctrlIncElementColor = Color.blue.brighter();
    Color elementIncColor = Color.gray;
    Color attributeIncColor = Color.green;
    Color exportIncColor = Color.pink;
    Font includedFont = new Font(UIManager.getFont("Tree.font").getName(), 0, UIManager.getFont("Tree.font").getSize());
    Font defalutFont = UIManager.getFont("Tree.font");

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.putClientProperty("html", null);
        this.setForeground(this.getLabelColor(object));
        this.setFont(this.getCustomFont(object, ((Component)this).getFont()));
        this.setIcon(this.getLabelIcon(object));
        return this;
    }

    protected Color getLabelColor(Object object) {
        ObjectModel objectModel;
        TNCommon tNCommon;
        boolean bl = false;
        if (object instanceof TNCommon) {
            tNCommon = (TNCommon)object;
            bl = tNCommon.isEditableObject();
        }
        if (object instanceof TNMultiElement || object instanceof TNMixed || object instanceof TNHedgeRef) {
            return bl ? this.ctrlElementColor : this.ctrlIncElementColor;
        }
        if (object instanceof TNConAttribute || object instanceof TNAttributeRef) {
            return bl ? this.attributeColor : this.attributeIncColor;
        }
        if (object instanceof TNObject && (objectModel = (ObjectModel)((TNObject)(tNCommon = (TNObject)object)).getObject()).isExportable()) {
            return bl ? this.exportColor : this.exportIncColor;
        }
        return bl ? this.elementColor : this.elementIncColor;
    }

    protected Font getCustomFont(Object object, Font font) {
        if (object instanceof TNCommon) {
            TNCommon tNCommon = (TNCommon)object;
            return tNCommon.isEditableObject() ? this.defalutFont : this.includedFont;
        }
        return font;
    }

    protected ImageIcon getLabelIcon(Object object) {
        if (object instanceof TNCommon) {
            return ((TNCommon)object).getImageIcon();
        }
        return null;
    }
}

