/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNCommon;

public abstract class TNAttribute
extends TNCommon {
    AttributeModel attribute;
    ActionListener action;

    protected TNAttribute(TreeNode treeNode, MessageListener messageListener, AttributeModel attributeModel, String string) {
        super(treeNode, messageListener, string);
        this.attribute = attributeModel;
    }

    public Object getObject() {
        return this.attribute;
    }

    public AttributeModel getAttribute() {
        return this.attribute;
    }

    protected String getRemoveName() {
        return this.toString();
    }

    protected ActionListener getActionListener() {
        if (this.action == null) {
            this.action = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TNAttribute.this.onAction(actionEvent);
                }
            };
        }
        return this.action;
    }

    protected void onAction(ActionEvent actionEvent) {
    }

    Object[][] createPopupMenu() {
        if (!this.isEditableObject()) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TNAttribute.this.removeBranch((Component)actionEvent.getSource(), false);
            }
        };
        Object[][] objectArray = new Object[][]{{"attributeRemove", "remove_attribute", actionListener, MainApp.getResString("IconEditRemoveBranch"), Boolean.TRUE}};
        return objectArray;
    }

    public void removeBranch(Component component, boolean bl) {
        Object[] objectArray;
        if (!bl) {
            objectArray = new String[]{this.getRemoveName()};
            String string = MessageFormat.format(MainApp.getResString("DoYouRemoveAttribute{0}?"), objectArray);
            int n = JOptionPane.showConfirmDialog(component, string, MainApp.getResString("RemoveConfirm"), 0);
            if (n != 0) {
                return;
            }
        }
        if (!(this.getTNParent().getObject() instanceof AttributeOperation)) {
            throw new InternalError("Unexpected error.");
        }
        objectArray = (AttributeOperation)this.getTNParent().getObject();
        objectArray.removeAttribute(this.getAttribute());
        this.getTNParent().sendTreeChangedMessage();
    }
}

