/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributePoolModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeRefModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ConcreteAttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.GuiUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNAttribute;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNAttributeRef;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNConAttribute;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class TNAttributePool
extends TNAttribute {
    AttributePoolModel pool;
    JPanel panel = null;
    JTextField nameField;
    JTextArea commentField;

    public TNAttributePool(TreeNode treeNode, AttributePoolModel attributePoolModel, MessageListener messageListener) {
        super(treeNode, messageListener, null, "IconAttPool");
        this.pool = attributePoolModel;
        this.initNode();
    }

    void initNode() {
        AttributeModel[] attributeModelArray = this.pool.getAttributes();
        ArrayList<TNAttribute> arrayList = new ArrayList<TNAttribute>();
        int n = 0;
        while (n < attributeModelArray.length) {
            if (attributeModelArray[n] instanceof ConcreteAttributeModel) {
                arrayList.add(new TNConAttribute(this.getParent(), this.getMessageListener(), (ConcreteAttributeModel)attributeModelArray[n]));
            } else if (attributeModelArray[n] instanceof AttributeRefModel) {
                arrayList.add(new TNAttributeRef(this.getParent(), this.getMessageListener(), (AttributeRefModel)attributeModelArray[n]));
            } else {
                throw new InternalError("Invalid attribute entry.");
            }
            ++n;
        }
        TreeNode[] treeNodeArray = new TreeNode[arrayList.size()];
        this.setChildren(arrayList.toArray(treeNodeArray));
    }

    public Object getObject() {
        return this.pool;
    }

    public JPanel getPropertyPane() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.nameField = new JTextField(20);
            this.panel.add(this.setupComponent(this.nameField, "attributePoolRole"));
            this.commentField = new JTextArea(3, 20);
            this.panel.add(this.setupTextArea(this.commentField, "attributeComment"));
        }
        this.updateComponentsFromData();
        return this.panel;
    }

    protected void updateDataFromComponents() {
        this.pool.setRole(this.nameField.getText());
        this.pool.setComment(this.commentField.getText());
        this.sendRepaintMessage();
    }

    protected void updateComponentsFromData() {
        this.nameField.setText(this.pool.getRole());
        this.commentField.setText(this.pool.getComment());
    }

    protected Object[][] getPopupMenuResource() {
        if (!this.isEditableObject()) {
            return null;
        }
        Object[][] objectArray = new Object[][]{{"addAttribute", "add_attr", this.getActionListener(), MainApp.getResString("IconAttribute"), Boolean.TRUE}, {"addAttributeRef", "add_attr_ref", this.getActionListener(), MainApp.getResString("IconAttPoolRef"), Boolean.TRUE}, {null}, {"RemoveBranch", "remove_branch", this.getActionListener(), MainApp.getResString("IconEditRemoveBranch"), Boolean.TRUE}};
        return objectArray;
    }

    protected void onAction(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "add_attr") {
            this.addAttribute((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_attr_ref") {
            this.addAttributeRef((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "remove_branch") {
            this.removeBranch((Component)actionEvent.getSource(), false);
        } else {
            throw new InternalError("No such event.");
        }
    }

    public void removeBranch(Component component, boolean bl) {
        if (!bl) {
            Object[] objectArray = new String[]{this.pool.getRole()};
            String string = MessageFormat.format(MainApp.getResString("DoYouRemoveAttributePool{0}?"), objectArray);
            int n = JOptionPane.showConfirmDialog(component, string, MainApp.getResString("RemoveConfirm"), 0);
            if (n != 0) {
                return;
            }
        }
        this.getModule().removeAttributePool(this.pool);
        this.getTNParent().sendTreeChangedMessage();
    }

    void addAttribute(Component component) {
        String string = GuiUtil.inputDialog(component, "inputAttributeName", "addAttribute");
        if (StringUtil.isNull(string)) {
            return;
        }
        this.pool.addAttribute(ElementUtil.getAttribute(string));
        this.sendTreeChangedMessage();
    }

    void addAttributeRef(Component component) {
        AttributePoolModel attributePoolModel = this.chooseAttributePool(component);
        if (attributePoolModel == null) {
            return;
        }
        this.pool.addAttribute(ElementUtil.getAttributeRef(attributePoolModel));
        this.sendTreeChangedMessage();
    }

    public String toString() {
        return "[" + this.pool.getRole() + "]";
    }

    public boolean getAllowsChildren() {
        return true;
    }
}

