/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractHedgeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributePoolModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.MixedModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.SequenceElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.GuiUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNAttributePool;
import jp.gr.java_conf.ccs2.util.SimpleEnumeration;
import jp.gr.java_conf.ccs2.util.StringUtil;

public abstract class TNCommon
implements TreeNode {
    private MessageListener messageListener = null;
    private TreeNode parent = null;
    private TreeNode[] children = null;
    private ImageIcon icon = null;
    KeyListener keyListener;
    FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            TNCommon.this.updateDataFromComponents();
        }
    };
    ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            TNCommon.this.updateDataFromComponents();
        }
    };
    ItemListener itemListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            TNCommon.this.updateDataFromComponents();
        }
    };
    JPopupMenu popMenu;
    protected static final String ADD_ATTRIBUTE = "add_attr";
    protected static final String ADD_ATTREF = "add_attr_ref";
    protected static final String ADD_ATTPOOL = "add_attr_pool";
    protected static final String ADD_MIXED = "add_mixed";
    protected static final String ADD_SEQUENCE = "add_seq";
    protected static final String ADD_CHOICE = "add_choice";
    protected static final String ADD_REF = "add_ref";
    protected static final String ADD_REF_REUSE = "add_ref_reuse";
    protected static final String ADD_HEDGEREF = "add_hedge_ref";
    protected static final String ADD_HEDGERULE = "add_hedge_rule";
    protected static final String ADD_NONE = "add_none";
    protected static final String ADD_EMPTY = "add_empty";
    protected static final String REMOVE_BRANCH = "remove_branch";
    protected static final String REMOVE_CONNECT = "remove_connect";
    protected static final String MOVE_UP = "move_up";
    protected static final String MOVE_DOWN = "move_down";
    protected static final String REMOVE_MODULE = "remove_module";
    protected static final String RELOAD_MODULE = "reload_module";
    protected static final String INCLUDE_MODULE = "include_module";
    protected static final ObjectModel OBJECTMODEL = new ObjectModel(null, "");
    protected static final ElementModel ELEMENTMODEL = new MixedModel(null);
    protected static final AbstractHedgeModel HEDGEMODEL = new SequenceElementModel(null);

    protected TNCommon(TreeNode treeNode, MessageListener messageListener, String string) {
        this.parent = treeNode;
        this.messageListener = messageListener;
        if (!StringUtil.isNull(string)) {
            try {
                URL uRL = string.getClass().getResource(this.getResourceString(string));
                if (uRL != null) {
                    this.icon = new ImageIcon(uRL);
                }
            }
            catch (RuntimeException runtimeException) {
                MainApp.getAppContext().getMonitor().warning("Icon file " + string + " not found.");
            }
        }
    }

    public JPanel getPropertyPaneGen(KeyListener keyListener) {
        this.keyListener = keyListener;
        return this.getPropertyPane();
    }

    public abstract JPanel getPropertyPane();

    public abstract Object getObject();

    public boolean isEditableObject() {
        return this.getMainModule() == this.getModule();
    }

    protected ModuleModel getMainModule() {
        if (this.getTNParent() != null) {
            return this.getTNParent().getMainModule();
        }
        MainApp.getAppContext().getMonitor().error("Stopped MainModule chain. : " + this.getClass().getName());
        throw new InternalError("Stopped MainModule chain.");
    }

    public ImageIcon getImageIcon() {
        return this.icon;
    }

    protected void sendRepaintMessage() {
        if (this.messageListener != null) {
            this.messageListener.message(null, 4, this);
        }
    }

    protected void sendTreeChangedMessage() {
        if (this.messageListener != null) {
            this.messageListener.message(null, 2, this);
        }
    }

    protected MessageListener getMessageListener() {
        return this.messageListener;
    }

    protected KeyListener getKeyListener() {
        if (this.keyListener == null) {
            throw new InternalError("KeyListener is null!");
        }
        return this.keyListener;
    }

    public TNCommon getTNParent() {
        if (this.getParent() instanceof TNCommon) {
            return (TNCommon)this.getParent();
        }
        return null;
    }

    protected String getResourceString(String string) {
        return MainApp.getResString(string);
    }

    public abstract void removeBranch(Component var1, boolean var2);

    protected JPanel setupTextArea(JTextArea jTextArea, String string) {
        jTextArea.setLineWrap(true);
        JPanel jPanel = this.setupComponentGen(jTextArea, string);
        jPanel.add(new JScrollPane(jTextArea));
        return jPanel;
    }

    protected JPanel setupComponent(Component component, String string) {
        JPanel jPanel = this.setupComponentGen(component, string);
        if (component instanceof ItemSelectable) {
            ((ItemSelectable)((Object)component)).addItemListener(this.itemListener);
        }
        if (component instanceof JTextComponent) {
            ((JTextField)component).addActionListener(this.actionListener);
        } else if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(this.actionListener);
        }
        this.addComponentAndLabel(jPanel, component, string);
        return jPanel;
    }

    protected JPanel setupButton(Component component, String string) {
        JPanel jPanel = this.setupComponentGen(component, string);
        this.addComponentAndLabel(jPanel, component, string);
        return jPanel;
    }

    protected JPanel setupItem(AbstractButton abstractButton, String string) {
        JPanel jPanel = this.setupComponentGen(abstractButton, string);
        this.addComponentAndLabel(jPanel, abstractButton, string);
        abstractButton.addItemListener(this.itemListener);
        return jPanel;
    }

    private JPanel setupComponentGen(Component component, String string) {
        component.addFocusListener(this.focusListener);
        component.addKeyListener(this.getKeyListener());
        component.setEnabled(this.isEditableObject());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(new TitledBorder(this.getResourceString(string)));
        jPanel.add(Box.createHorizontalStrut(6));
        return jPanel;
    }

    private void addComponentAndLabel(JPanel jPanel, Component component, String string) {
        String string2 = ((MainApp)MainApp.getAppContext()).getResourceStringNoWarning("PRE_" + string);
        if (string2 != null) {
            jPanel.add(new JLabel(string2));
        }
        jPanel.add(component);
        String string3 = ((MainApp)MainApp.getAppContext()).getResourceStringNoWarning("POST_" + string);
        if (string3 != null) {
            jPanel.add(new JLabel(string3));
        }
    }

    protected void updateDataFromComponents() {
    }

    protected void updateComponentsFromData() {
    }

    protected ModuleModel getModule() {
        TNCommon tNCommon = this;
        do {
            if (tNCommon.getObject() instanceof ModuleModel) {
                return (ModuleModel)tNCommon.getObject();
            }
            if (!(tNCommon.getObject() instanceof ElementOperation)) continue;
            return ((ElementOperation)tNCommon.getObject()).getParentModule();
        } while ((tNCommon = tNCommon.getTNParent()) != null);
        throw new InternalError("Can not find module object.");
    }

    protected AttributePoolModel chooseAttributePool(Component component) {
        Object object;
        TNCommon tNCommon = this;
        AttributePoolModel attributePoolModel = null;
        while (tNCommon != null) {
            if (tNCommon instanceof TNAttributePool) {
                attributePoolModel = (AttributePoolModel)tNCommon.getObject();
                break;
            }
            tNCommon = tNCommon.getTNParent();
        }
        AttributePoolModel[] attributePoolModelArray = this.getModule().getAllAttributePools(attributePoolModel);
        String[] stringArray = new String[attributePoolModelArray.length];
        int n = 0;
        while (n < attributePoolModelArray.length) {
            object = attributePoolModelArray[n].getRole();
            stringArray[n] = object;
            ++n;
        }
        object = new SelectionDialog(JOptionPane.getFrameForComponent(component), this.getResourceString("selectAttribute"), Arrays.asList(stringArray));
        ((Dialog)object).show();
        if (((SelectionDialog)object).getIndex() == -1) {
            return null;
        }
        return attributePoolModelArray[((SelectionDialog)object).getIndex()];
    }

    public TreeNode getParent() {
        return this.parent;
    }

    protected void setChildren(TreeNode[] treeNodeArray) {
        this.children = treeNodeArray;
    }

    protected TreeNode[] getChildren() {
        return this.children;
    }

    protected void addChild(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (this.getChildren() != null) {
            arrayList.addAll(Arrays.asList(this.getChildren()));
        }
        arrayList.add(treeNode);
        TreeNode[] treeNodeArray = new TreeNode[arrayList.size()];
        this.setChildren(arrayList.toArray(treeNodeArray));
    }

    public int getIndex(TreeNode treeNode) {
        if (this.children == null) {
            return -1;
        }
        int n = 0;
        while (n < this.children.length) {
            if (treeNode == this.children[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Enumeration children() {
        if (this.children == null) {
            return null;
        }
        return new SimpleEnumeration(this.children);
    }

    public TreeNode getChildAt(int n) {
        if (this.children == null) {
            return null;
        }
        return this.children[n];
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.length;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.length == 0;
    }

    public String toString() {
        return "[common]";
    }

    public final JPopupMenu getPopupMenu() {
        if (this.popMenu == null) {
            Object[][] objectArray = this.getPopupMenuResource();
            if (objectArray == null) {
                return null;
            }
            this.popMenu = GuiUtil.createPopupMenu(objectArray);
        }
        return this.popMenu;
    }

    protected void clearPopupMenu() {
        this.popMenu = null;
    }

    protected Object[][] getPopupMenuResource() {
        return null;
    }

    protected static Object[][] appendCustomMenuBefore(Object[][] objectArray, Object[] objectArray2) {
        Object[][] objectArrayArray = new Object[][]{objectArray2};
        return TNCommon.appendCustomMenuBefore(objectArray, (Object[])objectArrayArray);
    }

    protected static Object[][] appendCustomMenusBefore(Object[][] objectArray, Object[][] objectArray2) {
        if (objectArray2 == null) {
            return objectArray;
        }
        if (objectArray == null) {
            objectArray = new Object[0][0];
        }
        Object[][] objectArray3 = new Object[objectArray.length + objectArray2.length][];
        int n = 0;
        while (n < objectArray2.length) {
            objectArray3[n] = objectArray2[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray3[objectArray2.length + n2] = objectArray[n2];
            ++n2;
        }
        return objectArray3;
    }

    protected static Object[][] appendCustomMenuAfter(Object[][] objectArray, Object[] objectArray2) {
        Object[][] objectArray3 = new Object[][]{objectArray2};
        return TNCommon.appendCustomMenusAfter(objectArray, objectArray3);
    }

    protected static Object[][] appendCustomMenusAfter(Object[][] objectArray, Object[][] objectArray2) {
        if (objectArray2 == null) {
            return objectArray;
        }
        if (objectArray == null) {
            objectArray = new Object[0][0];
        }
        Object[][] objectArray3 = new Object[objectArray.length + objectArray2.length][];
        int n = 0;
        while (n < objectArray.length) {
            objectArray3[n] = objectArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            objectArray3[objectArray.length + n2] = objectArray2[n2];
            ++n2;
        }
        return objectArray3;
    }
}

