/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.tool.mkrelax.ConcreteAttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.DataType;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNAttribute;

public class TNConAttribute
extends TNAttribute {
    JPanel panel;
    JTextField nameField;
    JTextArea commentField;
    JCheckBox requireCheck;
    JButton typeButton;

    public TNConAttribute(TreeNode treeNode, MessageListener messageListener, ConcreteAttributeModel concreteAttributeModel) {
        super(treeNode, messageListener, concreteAttributeModel, "IconAttribute");
    }

    public ConcreteAttributeModel getConAttribute() {
        return (ConcreteAttributeModel)this.attribute;
    }

    public JPanel getPropertyPane() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.nameField = new JTextField(20);
            this.panel.add(this.setupComponent(this.nameField, "attributeName"));
            this.commentField = new JTextArea(3, 20);
            this.panel.add(this.setupTextArea(this.commentField, "attributeComment"));
            this.requireCheck = new JCheckBox();
            this.panel.add(this.setupItem(this.requireCheck, "attributeRequire"));
            this.typeButton = new JButton("-----");
            this.typeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TNConAttribute.this.selectDataType();
                }
            });
            this.panel.add(this.setupButton(this.typeButton, "attributeType"));
        }
        this.updateComponentsFromData();
        return this.panel;
    }

    protected Object[][] getPopupMenuResource() {
        Object[][] objectArray = this.createPopupMenu();
        return objectArray;
    }

    void selectDataType() {
        SelectionDialog selectionDialog = new SelectionDialog(JOptionPane.getFrameForComponent(this.typeButton), MainApp.getResString("selectDataType"), Arrays.asList(DataType.dataTypes));
        selectionDialog.show();
        if (selectionDialog.getIndex() == -1) {
            return;
        }
        this.typeButton.setText(DataType.dataTypes[selectionDialog.getIndex()].getTypeName());
        this.getConAttribute().setType(DataType.dataTypes[selectionDialog.getIndex()]);
        this.sendRepaintMessage();
    }

    protected void updateDataFromComponents() {
        this.getConAttribute().setName(this.nameField.getText());
        this.getConAttribute().setComment(this.commentField.getText());
        this.getConAttribute().setRequired(this.requireCheck.isSelected());
        this.sendRepaintMessage();
    }

    protected void updateComponentsFromData() {
        this.nameField.setText(this.getConAttribute().getName());
        this.commentField.setText(this.getConAttribute().getComment());
        this.requireCheck.setSelected(this.getConAttribute().isRequired());
        this.typeButton.setText(this.getConAttribute().getType().getTypeName());
    }

    public String toString() {
        String string = this.getConAttribute().getName() + ":" + this.getConAttribute().getType().getTypeName();
        if (this.getConAttribute().isRequired()) {
            string = string + " [required]";
        }
        return string;
    }

    public boolean getAllowsChildren() {
        return false;
    }
}

